/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-04-08 17:16:44 UTC)
 * on 2016-04-28 at 18:57:13 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.pubsub.model;

/**
 * Response for the `Pull` method.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Pub/Sub API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PullResponse extends com.google.api.client.json.GenericJson {

  /**
   * Received Pub/Sub messages. The Pub/Sub system will return zero messages if there are no more
   * available in the backlog. The Pub/Sub system may return fewer than the `maxMessages` requested
   * even if there are more messages available in the backlog.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ReceivedMessage> receivedMessages;

  /**
   * Received Pub/Sub messages. The Pub/Sub system will return zero messages if there are no more
   * available in the backlog. The Pub/Sub system may return fewer than the `maxMessages` requested
   * even if there are more messages available in the backlog.
   * @return value or {@code null} for none
   */
  public java.util.List<ReceivedMessage> getReceivedMessages() {
    return receivedMessages;
  }

  /**
   * Received Pub/Sub messages. The Pub/Sub system will return zero messages if there are no more
   * available in the backlog. The Pub/Sub system may return fewer than the `maxMessages` requested
   * even if there are more messages available in the backlog.
   * @param receivedMessages receivedMessages or {@code null} for none
   */
  public PullResponse setReceivedMessages(java.util.List<ReceivedMessage> receivedMessages) {
    this.receivedMessages = receivedMessages;
    return this;
  }

  @Override
  public PullResponse set(String fieldName, Object value) {
    return (PullResponse) super.set(fieldName, value);
  }

  @Override
  public PullResponse clone() {
    return (PullResponse) super.clone();
  }

}
