/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-04-08 17:16:44 UTC)
 * on 2016-04-28 at 18:57:13 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.pubsub.model;

/**
 * Response for the `ListSubscriptions` method.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Pub/Sub API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListSubscriptionsResponse extends com.google.api.client.json.GenericJson {

  /**
   * If not empty, indicates that there may be more subscriptions that match the request; this value
   * should be passed in a new `ListSubscriptionsRequest` to get more subscriptions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The subscriptions that match the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Subscription> subscriptions;

  static {
    // hack to force ProGuard to consider Subscription used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Subscription.class);
  }

  /**
   * If not empty, indicates that there may be more subscriptions that match the request; this value
   * should be passed in a new `ListSubscriptionsRequest` to get more subscriptions.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * If not empty, indicates that there may be more subscriptions that match the request; this value
   * should be passed in a new `ListSubscriptionsRequest` to get more subscriptions.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListSubscriptionsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The subscriptions that match the request.
   * @return value or {@code null} for none
   */
  public java.util.List<Subscription> getSubscriptions() {
    return subscriptions;
  }

  /**
   * The subscriptions that match the request.
   * @param subscriptions subscriptions or {@code null} for none
   */
  public ListSubscriptionsResponse setSubscriptions(java.util.List<Subscription> subscriptions) {
    this.subscriptions = subscriptions;
    return this;
  }

  @Override
  public ListSubscriptionsResponse set(String fieldName, Object value) {
    return (ListSubscriptionsResponse) super.set(fieldName, value);
  }

  @Override
  public ListSubscriptionsResponse clone() {
    return (ListSubscriptionsResponse) super.clone();
  }

}
