/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.extension.mapping.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.yulichang.adapter.AdapterHelper;
import com.github.yulichang.annotation.EntityMapping;
import com.github.yulichang.annotation.FieldMapping;
import com.github.yulichang.extension.mapping.mapper.MPJMappingWrapper;
import com.github.yulichang.extension.mapping.mapper.MPJTableInfo;
import com.github.yulichang.extension.mapping.mapper.MPJTableInfoHelper;
import com.github.yulichang.toolkit.SpringContentUtils;
import com.github.yulichang.toolkit.TableHelper;
import com.github.yulichang.toolkit.support.ColumnCache;
import com.github.yulichang.wrapper.segments.SelectCache;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class MPJTableFieldInfo {
    private final boolean isMappingEntity;
    private final boolean isMappingField;
    private Field bindField;
    private final boolean isRemoveBindField;
    private final Class<?> entityType;
    private Field field;
    private String property;
    private boolean isCollection;
    private Field thisField;
    private String thisProperty;
    private String thisColumn;
    private Class<?> joinClass;
    private String joinProperty;
    private String joinColumn;
    private Field joinField;
    private BaseMapper<?> joinMapper;
    private final MPJMappingWrapper wrapper;
    private final boolean isThrowExp;

    public MPJTableFieldInfo(Class<?> entityType, EntityMapping mapping, Field field) {
        this.entityType = entityType;
        this.isMappingEntity = true;
        this.isMappingField = false;
        this.initField(field);
        if (mapping.tag() != Object.class) {
            this.joinClass = mapping.tag();
        }
        this.isThrowExp = mapping.isThrowExp();
        this.initThisField(mapping.thisField());
        this.initJoinField(mapping.joinField());
        this.isRemoveBindField = this.checkArr(mapping.select()) && !Arrays.asList(mapping.select()).contains(this.joinProperty.trim()) && !Arrays.asList(mapping.select()).contains(this.joinColumn.trim());
        this.wrapper = new MPJMappingWrapper(mapping.first(), this.checkArr(mapping.select()) ? (this.isRemoveBindField ? this.propToColumn(this.joinClass, mapping.select(), this.joinColumn) : this.propToColumn(this.joinClass, mapping.select(), null)) : null, mapping.apply(), mapping.condition(), mapping.last(), mapping.orderByAsc(), mapping.orderByDesc());
    }

    public MPJTableFieldInfo(Class<?> entityType, FieldMapping mappingField, Field field) {
        this.entityType = entityType;
        this.isMappingEntity = false;
        this.isMappingField = true;
        field.setAccessible(true);
        this.field = field;
        this.property = field.getName();
        this.isCollection = Collection.class.isAssignableFrom(field.getType());
        if (this.isCollection && !List.class.isAssignableFrom(this.field.getType())) {
            throw ExceptionUtils.mpe((String)("\u5bf9\u591a\u5173\u7cfb\u7684\u6570\u636e\u7ed3\u6784\u76ee\u524d\u53ea\u652f\u6301 <List> \u6682\u4e0d\u652f\u6301\u5176\u4ed6Collection\u5b9e\u73b0 " + this.field.getType().getTypeName()), (Object[])new Object[0]);
        }
        this.joinClass = mappingField.tag();
        this.isThrowExp = mappingField.isThrowExp();
        this.initThisField(mappingField.thisField());
        this.initJoinField(mappingField.joinField());
        this.isRemoveBindField = !mappingField.select().equals(this.joinColumn.trim()) && !mappingField.select().equals(this.joinProperty.trim());
        this.wrapper = new MPJMappingWrapper(mappingField.first(), this.isRemoveBindField ? this.propToColumn(this.joinClass, new String[]{mappingField.select()}, this.joinColumn) : this.propToColumn(this.joinClass, new String[]{mappingField.select()}, null), mappingField.apply(), mappingField.condition(), mappingField.last(), mappingField.orderByAsc(), mappingField.orderByDesc());
        this.initBindField(mappingField.select());
    }

    private void initBindField(String bindName) {
        TableInfo info = TableHelper.get(this.joinClass);
        Assert.notNull((Object)info, (String)"\u672a\u6ce8\u518c\u7684\u5b9e\u4f53\u7c7b <%s>", (Object[])new Object[]{this.joinClass.getSimpleName()});
        Field field = info.getFieldList().stream().filter(i -> i.getProperty().equals(bindName)).findFirst().map(f -> this.getField(this.joinClass, (TableFieldInfo)f)).orElse(null);
        if (field == null && bindName.equals(info.getKeyProperty())) {
            field = ReflectionKit.getFieldList(this.joinClass).stream().filter(f -> f.getName().equals(info.getKeyProperty())).findFirst().orElse(null);
        }
        if (field == null) {
            field = info.getFieldList().stream().filter(i -> i.getColumn().equals(bindName)).map(f -> this.getField(this.joinClass, (TableFieldInfo)f)).findFirst().orElse(null);
            if (field == null && bindName.equals(info.getKeyColumn())) {
                field = ReflectionKit.getFieldList(this.joinClass).stream().filter(f -> f.getName().equals(info.getKeyProperty())).findFirst().orElse(null);
            }
            if (field == null) {
                throw ExceptionUtils.mpe((String)("\u5b57\u6bb5\u4e0d\u5b58\u5728 " + this.joinClass.getName() + " \uff0c" + bindName), (Object[])new Object[0]);
            }
        }
        this.bindField = field;
        this.bindField.setAccessible(true);
    }

    private void initJoinField(String joinField) {
        if (StringUtils.isNotBlank((CharSequence)joinField)) {
            this.joinProperty = joinField;
        } else {
            TableInfo info = this.getTableInfo(this.joinClass);
            Assert.isTrue((boolean)info.havePK(), (String)"\u5b9e\u4f53\u672a\u5b9a\u4e49\u4e3b\u952e %s ", (Object[])new Object[]{this.joinClass.getName()});
            this.joinProperty = info.getKeyProperty();
        }
        TableInfo joinTableInfo = this.getTableInfo(this.joinClass);
        TableFieldInfo joinFieldInfo = joinTableInfo.getFieldList().stream().filter(f -> f.getProperty().equals(this.joinProperty)).findFirst().orElse(null);
        if (joinFieldInfo == null) {
            if (AdapterHelper.getTableInfoAdapter().mpjHasPK(joinTableInfo) && this.joinProperty.equals(joinTableInfo.getKeyProperty())) {
                this.joinColumn = joinTableInfo.getKeyColumn();
                this.joinField = ReflectionKit.getFieldList(this.joinClass).stream().filter(i -> i.getName().equals(joinTableInfo.getKeyProperty())).findFirst().orElse(null);
            }
        } else {
            this.joinColumn = joinFieldInfo.getColumn();
            this.joinField = this.getField(this.joinClass, joinFieldInfo);
        }
        Assert.notNull((Object)this.joinField, (String)"\u6ce8\u89e3\u5c5e\u6027thisField\u4e0d\u5b58\u5728 %s , %s", (Object[])new Object[]{this.joinClass.getName(), StringUtils.isBlank((CharSequence)this.joinProperty) ? "\u4e3b\u952e" : this.joinProperty});
        Assert.notNull((Object)this.joinColumn, (String)"\u6ce8\u89e3\u5c5e\u6027thisField\u4e0d\u5b58\u5728 %s , %s", (Object[])new Object[]{this.joinClass.getName(), StringUtils.isBlank((CharSequence)this.joinProperty) ? "\u4e3b\u952e" : this.joinProperty});
        this.joinField.setAccessible(true);
    }

    private void initThisField(String thisField) {
        if (StringUtils.isNotBlank((CharSequence)thisField)) {
            this.thisProperty = thisField;
        } else {
            TableInfo info = this.getTableInfo(this.entityType);
            Assert.isTrue((boolean)info.havePK(), (String)"\u5b9e\u4f53\u672a\u5b9a\u4e49\u4e3b\u952e %s ", (Object[])new Object[]{this.entityType.getName()});
            this.thisProperty = info.getKeyProperty();
        }
        TableInfo tableInfo = this.getTableInfo(this.entityType);
        if (AdapterHelper.getTableInfoAdapter().mpjHasPK(tableInfo) && this.thisProperty.equals(tableInfo.getKeyProperty())) {
            this.thisField = ReflectionKit.getFieldList((Class)ClassUtils.getUserClass(this.entityType)).stream().filter(f -> f.getName().equals(tableInfo.getKeyProperty())).findFirst().orElse(null);
            Assert.notNull((Object)this.thisField, (String)"\u6ce8\u89e3\u5c5e\u6027thisField\u4e0d\u5b58\u5728 %s , %s", (Object[])new Object[]{this.entityType.getName(), StringUtils.isBlank((CharSequence)this.thisProperty) ? "\u4e3b\u952e" : this.thisProperty});
            this.thisColumn = tableInfo.getKeyColumn();
        } else {
            TableFieldInfo fieldInfo = tableInfo.getFieldList().stream().filter(f -> f.getProperty().equals(this.thisProperty)).findFirst().orElse(null);
            Assert.notNull((Object)fieldInfo, (String)"\u6ce8\u89e3\u5c5e\u6027thisField\u4e0d\u5b58\u5728 %s , %s", (Object[])new Object[]{this.entityType.getName(), StringUtils.isBlank((CharSequence)this.thisProperty) ? "\u4e3b\u952e" : this.thisProperty});
            this.thisField = this.getField(this.entityType, fieldInfo);
            this.thisColumn = fieldInfo.getColumn();
        }
        this.thisField.setAccessible(true);
    }

    private void initField(Field field) {
        ParameterizedType t;
        Type type;
        field.setAccessible(true);
        this.field = field;
        this.property = field.getName();
        this.isCollection = Collection.class.isAssignableFrom(field.getType());
        if (this.isCollection && !List.class.isAssignableFrom(this.field.getType())) {
            throw ExceptionUtils.mpe((String)("\u5bf9\u591a\u5173\u7cfb\u7684\u6570\u636e\u7ed3\u6784\u76ee\u524d\u53ea\u652f\u6301 <List> \u6682\u4e0d\u652f\u6301\u5176\u4ed6Collection\u5b9e\u73b0 " + this.field.getType().getTypeName()), (Object[])new Object[0]);
        }
        if (Map.class.isAssignableFrom(field.getType())) {
            throw ExceptionUtils.mpe((String)"\u6620\u5c04\u67e5\u8be2\u4e0d\u652f\u6301Map\u7ed3\u6784 <%s.%s>", (Object[])new Object[]{this.entityType.getSimpleName(), field.getName()});
        }
        if (field.getGenericType() instanceof ParameterizedType && (type = (t = (ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof ParameterizedType && ((ParameterizedType)type).getRawType() == Map.class) {
            throw ExceptionUtils.mpe((String)"\u6620\u5c04\u67e5\u8be2\u4e0d\u652f\u6301Map\u7ed3\u6784 <%s.%s>", (Object[])new Object[]{this.entityType.getSimpleName(), field.getName()});
        }
        if (List.class.isAssignableFrom(field.getType())) {
            if (field.getGenericType() instanceof ParameterizedType) {
                t = (ParameterizedType)field.getGenericType();
                this.joinClass = (Class)t.getActualTypeArguments()[0];
            }
        } else {
            this.joinClass = field.getType();
        }
    }

    private boolean checkArr(String[] arr) {
        if (Objects.isNull(arr) || arr.length <= 0) {
            return false;
        }
        return Arrays.stream(arr).anyMatch(StringUtils::isNotBlank);
    }

    private String propToColumn(Class<?> tag, String[] arr, String joinC) {
        Map mapField = ColumnCache.getMapField(tag);
        List args = null;
        if (this.checkArr(arr)) {
            args = Arrays.stream(arr).filter(StringUtils::isNotBlank).map(c -> {
                if (mapField.containsKey(c)) {
                    return ((SelectCache)mapField.get(c)).getColumn();
                }
                return c;
            }).collect(Collectors.toList());
            if (StringUtils.isNotBlank((CharSequence)joinC) && mapField.containsKey(joinC)) {
                args.add(((SelectCache)mapField.get(joinC)).getColumn());
            }
        }
        return Optional.ofNullable(args).map(i -> String.join((CharSequence)",", i)).orElse(null);
    }

    public BaseMapper<?> getJoinMapper() {
        if (this.joinMapper == null) {
            MPJTableInfo joinTableInfo = MPJTableInfoHelper.getTableInfo(this.joinClass);
            if (joinTableInfo == null) {
                throw ExceptionUtils.mpe((String)("\u672a\u6ce8\u518c mapper " + this.joinClass.getName()), (Object[])new Object[0]);
            }
            this.joinMapper = (BaseMapper)SpringContentUtils.getMapper(joinTableInfo.getEntityClass());
        }
        return this.joinMapper;
    }

    private TableInfo getTableInfo(Class<?> clazz) {
        TableInfo tableInfo = TableHelper.get(clazz);
        if (tableInfo == null) {
            throw ExceptionUtils.mpe((String)("\u672a\u6ce8\u518c mapper " + clazz.getName()), (Object[])new Object[0]);
        }
        return tableInfo;
    }

    private Field getField(Class<?> table, TableFieldInfo tableFieldInfo) {
        return AdapterHelper.getTableInfoAdapter().mpjGetField(tableFieldInfo, () -> (Field)ReflectionKit.getFieldMap((Class)table).get(tableFieldInfo.getProperty()));
    }

    public void fieldSet(Object o, Object val) {
        try {
            this.field.set(o, val);
        }
        catch (Exception e) {
            throw ExceptionUtils.mpe((String)("\u65e0\u6cd5\u8bbe\u7f6e\u5173\u8054\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u5173\u8054\u5b57\u6bb5\u6570\u636e\u7c7b\u578b\u662f\u5426\u5339\u914d " + this.entityType.getName() + " , " + this.field.getName() + " , " + o.getClass().getName()), (Object[])new Object[0]);
        }
    }

    public Object thisFieldGet(Object o) {
        try {
            return this.getThisField().get(o);
        }
        catch (Exception e) {
            throw ExceptionUtils.mpe((String)("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u5173\u8054\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u5173\u8054\u5b57\u6bb5\u662f\u5426\u5339\u914d " + this.entityType.getName() + " , " + this.thisField.getName() + " , " + o.getClass().getName()), (Object[])new Object[0]);
        }
    }

    public Object joinFieldGet(Object o) {
        try {
            return this.getJoinField().get(o);
        }
        catch (Exception e) {
            throw ExceptionUtils.mpe((String)("\u65e0\u6cd5\u8bbe\u7f6e\u5173\u8054\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u5173\u8054\u5b57\u6bb5\u6570\u636e\u7c7b\u578b\u662f\u5426\u5339\u914d " + this.joinClass.getName() + " , " + this.joinField.getName() + " , " + o.getClass().getName()), (Object[])new Object[0]);
        }
    }

    public Object bindFieldGet(Object o) {
        try {
            return this.getBindField().get(o);
        }
        catch (Exception e) {
            throw ExceptionUtils.mpe((String)("\u65e0\u6cd5\u8bbe\u7f6e\u5173\u8054\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u5173\u8054\u5b57\u6bb5\u6570\u636e\u7c7b\u578b\u662f\u5426\u5339\u914d " + this.joinClass.getName() + " , " + this.bindField.getName() + " , " + o.getClass().getName()), (Object[])new Object[0]);
        }
    }

    public void joinFieldSetNull(Object o) {
        try {
            this.joinField.set(o, null);
        }
        catch (Exception e) {
            throw ExceptionUtils.mpe((String)("\u65e0\u6cd5\u8bbe\u7f6e\u5173\u8054\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u5173\u8054\u5b57\u6bb5\u6570\u636e\u7c7b\u578b\u662f\u5426\u5339\u914d " + this.entityType.getName() + " , " + this.joinField.getName() + " , " + o.getClass().getName()), (Object[])new Object[0]);
        }
    }

    public void removeJoinField(List<?> joinList) {
        if (this.isMappingEntity() && this.isRemoveBindField()) {
            joinList.forEach(this::joinFieldSetNull);
        }
    }

    public static <T> void bind(MPJTableFieldInfo fieldInfo, T i, List<?> data) {
        if (fieldInfo.isCollection()) {
            fieldInfo.fieldSet(i, data);
        } else {
            if (data.size() > 1 && fieldInfo.isThrowExp()) {
                throw ExceptionUtils.mpe((String)("Expected one result (or null) to be returned by select, but found: " + data.size() + " , " + fieldInfo.getProperty()), (Object[])new Object[0]);
            }
            fieldInfo.fieldSet(i, data.stream().findFirst().orElse(null));
        }
    }

    public boolean isMappingEntity() {
        return this.isMappingEntity;
    }

    public boolean isMappingField() {
        return this.isMappingField;
    }

    public Field getBindField() {
        return this.bindField;
    }

    public boolean isRemoveBindField() {
        return this.isRemoveBindField;
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public Field getField() {
        return this.field;
    }

    public String getProperty() {
        return this.property;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public Field getThisField() {
        return this.thisField;
    }

    public String getThisProperty() {
        return this.thisProperty;
    }

    public String getThisColumn() {
        return this.thisColumn;
    }

    public Class<?> getJoinClass() {
        return this.joinClass;
    }

    public String getJoinProperty() {
        return this.joinProperty;
    }

    public String getJoinColumn() {
        return this.joinColumn;
    }

    public Field getJoinField() {
        return this.joinField;
    }

    public MPJMappingWrapper getWrapper() {
        return this.wrapper;
    }

    public boolean isThrowExp() {
        return this.isThrowExp;
    }

    public String toString() {
        return "MPJTableFieldInfo(isMappingEntity=" + this.isMappingEntity() + ", isMappingField=" + this.isMappingField() + ", bindField=" + this.getBindField() + ", isRemoveBindField=" + this.isRemoveBindField() + ", entityType=" + this.getEntityType() + ", field=" + this.getField() + ", property=" + this.getProperty() + ", isCollection=" + this.isCollection() + ", thisField=" + this.getThisField() + ", thisProperty=" + this.getThisProperty() + ", thisColumn=" + this.getThisColumn() + ", joinClass=" + this.getJoinClass() + ", joinProperty=" + this.getJoinProperty() + ", joinColumn=" + this.getJoinColumn() + ", joinField=" + this.getJoinField() + ", joinMapper=" + this.getJoinMapper() + ", wrapper=" + this.getWrapper() + ", isThrowExp=" + this.isThrowExp() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MPJTableFieldInfo)) {
            return false;
        }
        MPJTableFieldInfo other = (MPJTableFieldInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isMappingEntity() != other.isMappingEntity()) {
            return false;
        }
        if (this.isMappingField() != other.isMappingField()) {
            return false;
        }
        if (this.isRemoveBindField() != other.isRemoveBindField()) {
            return false;
        }
        if (this.isCollection() != other.isCollection()) {
            return false;
        }
        if (this.isThrowExp() != other.isThrowExp()) {
            return false;
        }
        Field this$bindField = this.getBindField();
        Field other$bindField = other.getBindField();
        if (this$bindField == null ? other$bindField != null : !((Object)this$bindField).equals(other$bindField)) {
            return false;
        }
        Class<?> this$entityType = this.getEntityType();
        Class<?> other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
            return false;
        }
        Field this$field = this.getField();
        Field other$field = other.getField();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        String this$property = this.getProperty();
        String other$property = other.getProperty();
        if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
            return false;
        }
        Field this$thisField = this.getThisField();
        Field other$thisField = other.getThisField();
        if (this$thisField == null ? other$thisField != null : !((Object)this$thisField).equals(other$thisField)) {
            return false;
        }
        String this$thisProperty = this.getThisProperty();
        String other$thisProperty = other.getThisProperty();
        if (this$thisProperty == null ? other$thisProperty != null : !this$thisProperty.equals(other$thisProperty)) {
            return false;
        }
        String this$thisColumn = this.getThisColumn();
        String other$thisColumn = other.getThisColumn();
        if (this$thisColumn == null ? other$thisColumn != null : !this$thisColumn.equals(other$thisColumn)) {
            return false;
        }
        Class<?> this$joinClass = this.getJoinClass();
        Class<?> other$joinClass = other.getJoinClass();
        if (this$joinClass == null ? other$joinClass != null : !this$joinClass.equals(other$joinClass)) {
            return false;
        }
        String this$joinProperty = this.getJoinProperty();
        String other$joinProperty = other.getJoinProperty();
        if (this$joinProperty == null ? other$joinProperty != null : !this$joinProperty.equals(other$joinProperty)) {
            return false;
        }
        String this$joinColumn = this.getJoinColumn();
        String other$joinColumn = other.getJoinColumn();
        if (this$joinColumn == null ? other$joinColumn != null : !this$joinColumn.equals(other$joinColumn)) {
            return false;
        }
        Field this$joinField = this.getJoinField();
        Field other$joinField = other.getJoinField();
        if (this$joinField == null ? other$joinField != null : !((Object)this$joinField).equals(other$joinField)) {
            return false;
        }
        BaseMapper<?> this$joinMapper = this.getJoinMapper();
        BaseMapper<?> other$joinMapper = other.getJoinMapper();
        if (this$joinMapper == null ? other$joinMapper != null : !this$joinMapper.equals(other$joinMapper)) {
            return false;
        }
        MPJMappingWrapper this$wrapper = this.getWrapper();
        MPJMappingWrapper other$wrapper = other.getWrapper();
        return !(this$wrapper == null ? other$wrapper != null : !this$wrapper.equals(other$wrapper));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MPJTableFieldInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMappingEntity() ? 79 : 97);
        result = result * 59 + (this.isMappingField() ? 79 : 97);
        result = result * 59 + (this.isRemoveBindField() ? 79 : 97);
        result = result * 59 + (this.isCollection() ? 79 : 97);
        result = result * 59 + (this.isThrowExp() ? 79 : 97);
        Field $bindField = this.getBindField();
        result = result * 59 + ($bindField == null ? 43 : ((Object)$bindField).hashCode());
        Class<?> $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
        Field $field = this.getField();
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        String $property = this.getProperty();
        result = result * 59 + ($property == null ? 43 : $property.hashCode());
        Field $thisField = this.getThisField();
        result = result * 59 + ($thisField == null ? 43 : ((Object)$thisField).hashCode());
        String $thisProperty = this.getThisProperty();
        result = result * 59 + ($thisProperty == null ? 43 : $thisProperty.hashCode());
        String $thisColumn = this.getThisColumn();
        result = result * 59 + ($thisColumn == null ? 43 : $thisColumn.hashCode());
        Class<?> $joinClass = this.getJoinClass();
        result = result * 59 + ($joinClass == null ? 43 : $joinClass.hashCode());
        String $joinProperty = this.getJoinProperty();
        result = result * 59 + ($joinProperty == null ? 43 : $joinProperty.hashCode());
        String $joinColumn = this.getJoinColumn();
        result = result * 59 + ($joinColumn == null ? 43 : $joinColumn.hashCode());
        Field $joinField = this.getJoinField();
        result = result * 59 + ($joinField == null ? 43 : ((Object)$joinField).hashCode());
        BaseMapper<?> $joinMapper = this.getJoinMapper();
        result = result * 59 + ($joinMapper == null ? 43 : $joinMapper.hashCode());
        MPJMappingWrapper $wrapper = this.getWrapper();
        result = result * 59 + ($wrapper == null ? 43 : $wrapper.hashCode());
        return result;
    }
}

