/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.ulid;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

public final class Ulid
implements Serializable,
Comparable<Ulid> {
    private static final long serialVersionUID = 2625269413446854731L;
    private final long msb;
    private final long lsb;
    public static final int ULID_CHARS = 26;
    public static final int TIME_CHARS = 10;
    public static final int RANDOM_CHARS = 16;
    public static final int ULID_BYTES = 16;
    public static final int TIME_BYTES = 6;
    public static final int RANDOM_BYTES = 10;
    public static final Ulid MIN;
    public static final Ulid MAX;
    static final byte[] ALPHABET_VALUES;
    static final char[] ALPHABET_UPPERCASE;
    static final char[] ALPHABET_LOWERCASE;
    private static final long INCREMENT_OVERFLOW = 0L;

    public Ulid(Ulid ulid) {
        this.msb = ulid.msb;
        this.lsb = ulid.lsb;
    }

    public Ulid(long mostSignificantBits, long leastSignificantBits) {
        this.msb = mostSignificantBits;
        this.lsb = leastSignificantBits;
    }

    public Ulid(long time, byte[] random) {
        if ((time & 0xFFFF000000000000L) != 0L) {
            throw new IllegalArgumentException("Invalid time value");
        }
        if (random == null || random.length != 10) {
            throw new IllegalArgumentException("Invalid random bytes");
        }
        long long0 = 0L;
        long long1 = 0L;
        long0 |= time << 16;
        long0 |= (long)(random[0] & 0xFF) << 8;
        long0 |= (long)(random[1] & 0xFF);
        long1 |= (long)(random[2] & 0xFF) << 56;
        long1 |= (long)(random[3] & 0xFF) << 48;
        long1 |= (long)(random[4] & 0xFF) << 40;
        long1 |= (long)(random[5] & 0xFF) << 32;
        long1 |= (long)(random[6] & 0xFF) << 24;
        long1 |= (long)(random[7] & 0xFF) << 16;
        long1 |= (long)(random[8] & 0xFF) << 8;
        this.msb = long0;
        this.lsb = long1 |= (long)(random[9] & 0xFF);
    }

    public static Ulid fast() {
        long time = System.currentTimeMillis();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        return new Ulid(time << 16 | random.nextLong() & 0xFFFFL, random.nextLong());
    }

    public static Ulid min(long time) {
        return new Ulid(time << 16 | 0L, 0L);
    }

    public static Ulid max(long time) {
        return new Ulid(time << 16 | 0xFFFFL, -1L);
    }

    public static Ulid from(UUID uuid) {
        return new Ulid(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static Ulid from(byte[] bytes) {
        if (bytes == null || bytes.length != 16) {
            throw new IllegalArgumentException("Invalid ULID bytes");
        }
        long msb = 0L;
        long lsb = 0L;
        msb |= ((long)bytes[0] & 0xFFL) << 56;
        msb |= ((long)bytes[1] & 0xFFL) << 48;
        msb |= ((long)bytes[2] & 0xFFL) << 40;
        msb |= ((long)bytes[3] & 0xFFL) << 32;
        msb |= ((long)bytes[4] & 0xFFL) << 24;
        msb |= ((long)bytes[5] & 0xFFL) << 16;
        msb |= ((long)bytes[6] & 0xFFL) << 8;
        msb |= (long)bytes[7] & 0xFFL;
        lsb |= ((long)bytes[8] & 0xFFL) << 56;
        lsb |= ((long)bytes[9] & 0xFFL) << 48;
        lsb |= ((long)bytes[10] & 0xFFL) << 40;
        lsb |= ((long)bytes[11] & 0xFFL) << 32;
        lsb |= ((long)bytes[12] & 0xFFL) << 24;
        lsb |= ((long)bytes[13] & 0xFFL) << 16;
        lsb |= ((long)bytes[14] & 0xFFL) << 8;
        return new Ulid(msb, lsb |= (long)bytes[15] & 0xFFL);
    }

    public static Ulid from(String string) {
        char[] chars = Ulid.toCharArray(string);
        long time = 0L;
        long random0 = 0L;
        long random1 = 0L;
        time |= (long)ALPHABET_VALUES[chars[0]] << 45;
        time |= (long)ALPHABET_VALUES[chars[1]] << 40;
        time |= (long)ALPHABET_VALUES[chars[2]] << 35;
        time |= (long)ALPHABET_VALUES[chars[3]] << 30;
        time |= (long)ALPHABET_VALUES[chars[4]] << 25;
        time |= (long)ALPHABET_VALUES[chars[5]] << 20;
        time |= (long)ALPHABET_VALUES[chars[6]] << 15;
        time |= (long)ALPHABET_VALUES[chars[7]] << 10;
        time |= (long)ALPHABET_VALUES[chars[8]] << 5;
        time |= (long)ALPHABET_VALUES[chars[9]];
        random0 |= (long)ALPHABET_VALUES[chars[10]] << 35;
        random0 |= (long)ALPHABET_VALUES[chars[11]] << 30;
        random0 |= (long)ALPHABET_VALUES[chars[12]] << 25;
        random0 |= (long)ALPHABET_VALUES[chars[13]] << 20;
        random0 |= (long)ALPHABET_VALUES[chars[14]] << 15;
        random0 |= (long)ALPHABET_VALUES[chars[15]] << 10;
        random0 |= (long)ALPHABET_VALUES[chars[16]] << 5;
        random0 |= (long)ALPHABET_VALUES[chars[17]];
        random1 |= (long)ALPHABET_VALUES[chars[18]] << 35;
        random1 |= (long)ALPHABET_VALUES[chars[19]] << 30;
        random1 |= (long)ALPHABET_VALUES[chars[20]] << 25;
        random1 |= (long)ALPHABET_VALUES[chars[21]] << 20;
        random1 |= (long)ALPHABET_VALUES[chars[22]] << 15;
        random1 |= (long)ALPHABET_VALUES[chars[23]] << 10;
        random1 |= (long)ALPHABET_VALUES[chars[24]] << 5;
        long msb = time << 16 | random0 >>> 24;
        long lsb = random0 << 40 | (random1 |= (long)ALPHABET_VALUES[chars[25]]) & 0xFFFFFFFFFFL;
        return new Ulid(msb, lsb);
    }

    public UUID toUuid() {
        return new UUID(this.msb, this.lsb);
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[]{(byte)(this.msb >>> 56), (byte)(this.msb >>> 48), (byte)(this.msb >>> 40), (byte)(this.msb >>> 32), (byte)(this.msb >>> 24), (byte)(this.msb >>> 16), (byte)(this.msb >>> 8), (byte)this.msb, (byte)(this.lsb >>> 56), (byte)(this.lsb >>> 48), (byte)(this.lsb >>> 40), (byte)(this.lsb >>> 32), (byte)(this.lsb >>> 24), (byte)(this.lsb >>> 16), (byte)(this.lsb >>> 8), (byte)this.lsb};
        return bytes;
    }

    public String toString() {
        return this.toString(ALPHABET_UPPERCASE);
    }

    public String toLowerCase() {
        return this.toString(ALPHABET_LOWERCASE);
    }

    public Ulid toRfc4122() {
        long msb4 = this.msb & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        long lsb4 = this.lsb & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new Ulid(msb4, lsb4);
    }

    public Instant getInstant() {
        return Instant.ofEpochMilli(this.getTime());
    }

    public static Instant getInstant(String string) {
        return Instant.ofEpochMilli(Ulid.getTime(string));
    }

    public long getTime() {
        return this.msb >>> 16;
    }

    public static long getTime(String string) {
        char[] chars = Ulid.toCharArray(string);
        long time = 0L;
        time |= (long)ALPHABET_VALUES[chars[0]] << 45;
        time |= (long)ALPHABET_VALUES[chars[1]] << 40;
        time |= (long)ALPHABET_VALUES[chars[2]] << 35;
        time |= (long)ALPHABET_VALUES[chars[3]] << 30;
        time |= (long)ALPHABET_VALUES[chars[4]] << 25;
        time |= (long)ALPHABET_VALUES[chars[5]] << 20;
        time |= (long)ALPHABET_VALUES[chars[6]] << 15;
        time |= (long)ALPHABET_VALUES[chars[7]] << 10;
        time |= (long)ALPHABET_VALUES[chars[8]] << 5;
        return time |= (long)ALPHABET_VALUES[chars[9]];
    }

    public byte[] getRandom() {
        byte[] bytes = new byte[]{(byte)(this.msb >>> 8), (byte)this.msb, (byte)(this.lsb >>> 56), (byte)(this.lsb >>> 48), (byte)(this.lsb >>> 40), (byte)(this.lsb >>> 32), (byte)(this.lsb >>> 24), (byte)(this.lsb >>> 16), (byte)(this.lsb >>> 8), (byte)this.lsb};
        return bytes;
    }

    public static byte[] getRandom(String string) {
        char[] chars = Ulid.toCharArray(string);
        long random0 = 0L;
        long random1 = 0L;
        random0 |= (long)ALPHABET_VALUES[chars[10]] << 35;
        random0 |= (long)ALPHABET_VALUES[chars[11]] << 30;
        random0 |= (long)ALPHABET_VALUES[chars[12]] << 25;
        random0 |= (long)ALPHABET_VALUES[chars[13]] << 20;
        random0 |= (long)ALPHABET_VALUES[chars[14]] << 15;
        random0 |= (long)ALPHABET_VALUES[chars[15]] << 10;
        random0 |= (long)ALPHABET_VALUES[chars[16]] << 5;
        random0 |= (long)ALPHABET_VALUES[chars[17]];
        random1 |= (long)ALPHABET_VALUES[chars[18]] << 35;
        random1 |= (long)ALPHABET_VALUES[chars[19]] << 30;
        random1 |= (long)ALPHABET_VALUES[chars[20]] << 25;
        random1 |= (long)ALPHABET_VALUES[chars[21]] << 20;
        random1 |= (long)ALPHABET_VALUES[chars[22]] << 15;
        random1 |= (long)ALPHABET_VALUES[chars[23]] << 10;
        random1 |= (long)ALPHABET_VALUES[chars[24]] << 5;
        byte[] bytes = new byte[]{(byte)(random0 >>> 32), (byte)(random0 >>> 24), (byte)(random0 >>> 16), (byte)(random0 >>> 8), (byte)random0, (byte)((random1 |= (long)ALPHABET_VALUES[chars[25]]) >>> 32), (byte)(random1 >>> 24), (byte)(random1 >>> 16), (byte)(random1 >>> 8), (byte)random1};
        return bytes;
    }

    public long getMostSignificantBits() {
        return this.msb;
    }

    public long getLeastSignificantBits() {
        return this.lsb;
    }

    public Ulid increment() {
        long newMsb = this.msb;
        long newLsb = this.lsb + 1L;
        if (newLsb == 0L) {
            ++newMsb;
        }
        return new Ulid(newMsb, newLsb);
    }

    public static boolean isValid(String string) {
        return string != null && Ulid.isValidCharArray(string.toCharArray());
    }

    public int hashCode() {
        long bits = this.msb ^ this.lsb;
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass() != Ulid.class) {
            return false;
        }
        Ulid that = (Ulid)other;
        if (this.lsb != that.lsb) {
            return false;
        }
        return this.msb == that.msb;
    }

    @Override
    public int compareTo(Ulid that) {
        long min = Long.MIN_VALUE;
        long a = this.msb + Long.MIN_VALUE;
        long b = that.msb + Long.MIN_VALUE;
        if (a > b) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        long c = this.lsb + Long.MIN_VALUE;
        long d = that.lsb + Long.MIN_VALUE;
        if (c > d) {
            return 1;
        }
        if (c < d) {
            return -1;
        }
        return 0;
    }

    String toString(char[] alphabet) {
        char[] chars = new char[26];
        long time = this.msb >>> 16;
        long random0 = (this.msb & 0xFFFFL) << 24 | this.lsb >>> 40;
        long random1 = this.lsb & 0xFFFFFFFFFFL;
        chars[0] = alphabet[(int)(time >>> 45 & 0x1FL)];
        chars[1] = alphabet[(int)(time >>> 40 & 0x1FL)];
        chars[2] = alphabet[(int)(time >>> 35 & 0x1FL)];
        chars[3] = alphabet[(int)(time >>> 30 & 0x1FL)];
        chars[4] = alphabet[(int)(time >>> 25 & 0x1FL)];
        chars[5] = alphabet[(int)(time >>> 20 & 0x1FL)];
        chars[6] = alphabet[(int)(time >>> 15 & 0x1FL)];
        chars[7] = alphabet[(int)(time >>> 10 & 0x1FL)];
        chars[8] = alphabet[(int)(time >>> 5 & 0x1FL)];
        chars[9] = alphabet[(int)(time & 0x1FL)];
        chars[10] = alphabet[(int)(random0 >>> 35 & 0x1FL)];
        chars[11] = alphabet[(int)(random0 >>> 30 & 0x1FL)];
        chars[12] = alphabet[(int)(random0 >>> 25 & 0x1FL)];
        chars[13] = alphabet[(int)(random0 >>> 20 & 0x1FL)];
        chars[14] = alphabet[(int)(random0 >>> 15 & 0x1FL)];
        chars[15] = alphabet[(int)(random0 >>> 10 & 0x1FL)];
        chars[16] = alphabet[(int)(random0 >>> 5 & 0x1FL)];
        chars[17] = alphabet[(int)(random0 & 0x1FL)];
        chars[18] = alphabet[(int)(random1 >>> 35 & 0x1FL)];
        chars[19] = alphabet[(int)(random1 >>> 30 & 0x1FL)];
        chars[20] = alphabet[(int)(random1 >>> 25 & 0x1FL)];
        chars[21] = alphabet[(int)(random1 >>> 20 & 0x1FL)];
        chars[22] = alphabet[(int)(random1 >>> 15 & 0x1FL)];
        chars[23] = alphabet[(int)(random1 >>> 10 & 0x1FL)];
        chars[24] = alphabet[(int)(random1 >>> 5 & 0x1FL)];
        chars[25] = alphabet[(int)(random1 & 0x1FL)];
        return new String(chars);
    }

    static char[] toCharArray(String string) {
        char[] chars;
        char[] cArray = chars = string == null ? null : string.toCharArray();
        if (!Ulid.isValidCharArray(chars)) {
            throw new IllegalArgumentException(String.format("Invalid ULID: \"%s\"", string));
        }
        return chars;
    }

    static boolean isValidCharArray(char[] chars) {
        if (chars == null || chars.length != 26) {
            return false;
        }
        if ((ALPHABET_VALUES[chars[0]] & 0x18) != 0) {
            return false;
        }
        for (int i = 0; i < chars.length; ++i) {
            if (ALPHABET_VALUES[chars[i]] != -1) continue;
            return false;
        }
        return true;
    }

    static {
        int i;
        MIN = new Ulid(0L, 0L);
        MAX = new Ulid(-1L, -1L);
        ALPHABET_VALUES = new byte[256];
        ALPHABET_UPPERCASE = "0123456789ABCDEFGHJKMNPQRSTVWXYZ".toCharArray();
        ALPHABET_LOWERCASE = "0123456789abcdefghjkmnpqrstvwxyz".toCharArray();
        Arrays.fill(ALPHABET_VALUES, (byte)-1);
        for (i = 0; i < ALPHABET_UPPERCASE.length; ++i) {
            Ulid.ALPHABET_VALUES[Ulid.ALPHABET_UPPERCASE[i]] = (byte)i;
        }
        for (i = 0; i < ALPHABET_LOWERCASE.length; ++i) {
            Ulid.ALPHABET_VALUES[Ulid.ALPHABET_LOWERCASE[i]] = (byte)i;
        }
        Ulid.ALPHABET_VALUES[79] = 0;
        Ulid.ALPHABET_VALUES[73] = 1;
        Ulid.ALPHABET_VALUES[76] = 1;
        Ulid.ALPHABET_VALUES[111] = 0;
        Ulid.ALPHABET_VALUES[105] = 1;
        Ulid.ALPHABET_VALUES[108] = 1;
    }
}

