/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.channel.loop;

import com.gettyio.core.logging.InternalLogger;
import com.gettyio.core.logging.InternalLoggerFactory;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class SelectedSelector
extends Selector {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SelectedSelector.class);
    private volatile boolean mark = false;
    private final int SELECTOR_AUTO_REBUILD_THRESHOLD = 512;
    private int selectCnt = 1;
    private final long timeoutMillis = 1000L;
    private Selector selector;

    public SelectedSelector(Selector selector) {
        this.selector = selector;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public synchronized SelectionKey register(SelectableChannel channel, int op) throws ClosedChannelException {
        this.mark = true;
        this.selector.wakeup();
        SelectionKey register = channel.register(this.selector, op);
        this.mark = false;
        return register;
    }

    public synchronized SelectionKey register(SelectableChannel channel, int op, Object att) throws ClosedChannelException {
        this.mark = true;
        this.selector.wakeup();
        SelectionKey register = channel.register(this.selector, op, att);
        this.mark = false;
        return register;
    }

    @Override
    public boolean isOpen() {
        return this.selector.isOpen();
    }

    @Override
    public SelectorProvider provider() {
        return this.selector.provider();
    }

    @Override
    public Set<SelectionKey> keys() {
        return this.selector.keys();
    }

    @Override
    public Set<SelectionKey> selectedKeys() {
        return this.selector.selectedKeys();
    }

    @Override
    public int selectNow() throws IOException {
        return this.selector.selectNow();
    }

    @Override
    public int select(long timeout) throws IOException {
        return this.selector.select(timeout);
    }

    @Override
    public int select() throws IOException {
        long currentTimeNanos = System.nanoTime();
        while (true) {
            if (this.mark) {
                continue;
            }
            int select = this.selector.select(1000L);
            if (select >= 1) {
                return select;
            }
            ++this.selectCnt;
            long time = System.nanoTime();
            if (time - TimeUnit.MILLISECONDS.toNanos(1000L) >= currentTimeNanos) {
                this.selectCnt = 1;
                continue;
            }
            if (this.selectCnt < 512) continue;
            this.rebuildSelector();
            this.selectCnt = 1;
        }
    }

    @Override
    public Selector wakeup() {
        return this.selector.wakeup();
    }

    @Override
    public void close() throws IOException {
        this.selector.close();
    }

    public void rebuildSelector() {
        this.rebuildSelector0();
    }

    private void rebuildSelector0() {
        Selector oldSelector = this.selector;
        Selector newSelectorTuple = null;
        try {
            newSelectorTuple = Selector.open();
        }
        catch (IOException e) {
            logger.warn("Failed to create a new Selector.", e);
            return;
        }
        int nChannels = 0;
        for (SelectionKey key : oldSelector.keys()) {
            Object a = key.attachment();
            try {
                if (!key.isValid() || key.channel().keyFor(newSelectorTuple) != null) continue;
                int interestOps = key.interestOps();
                key.cancel();
                SelectionKey newKey = key.channel().register(newSelectorTuple, interestOps, a);
                ++nChannels;
            }
            catch (Exception e) {
                logger.warn("Failed to re-register a Channel to the new Selector.", e);
            }
        }
        this.selector = newSelectorTuple;
        try {
            oldSelector.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close the old Selector.", e);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Migrated " + nChannels + " channel(s) to the new Selector.");
        }
    }
}

