/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.buffer;

import com.gettyio.core.buffer.AbstractBufferWriter;
import com.gettyio.core.buffer.ChannelByteBuffer;
import com.gettyio.core.buffer.ChunkPool;
import com.gettyio.core.channel.SocketChannel;
import com.gettyio.core.logging.InternalLogger;
import com.gettyio.core.logging.InternalLoggerFactory;
import com.gettyio.core.util.LinkedBlockQueue;
import com.gettyio.core.util.LinkedQueue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;

public final class NioBufferWriter
extends AbstractBufferWriter<ChannelByteBuffer> {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(NioBufferWriter.class);
    private final LinkedQueue<ChannelByteBuffer> queue;

    public NioBufferWriter(ChunkPool chunkPool, int bufferWriterQueueSize, int chunkPoolBlockTime) {
        this.chunkPool = chunkPool;
        this.chunkPoolBlockTime = chunkPoolBlockTime;
        this.queue = new LinkedBlockQueue<ChannelByteBuffer>(bufferWriterQueueSize);
    }

    public void write(SocketChannel socketChannel, byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            IOException ioException = new IOException("OutputStream has closed");
            LOGGER.error(ioException.getMessage(), ioException);
            throw ioException;
        }
        if (len <= 0 || b.length == 0) {
            return;
        }
        try {
            ByteBuffer chunkPage = this.chunkPool.allocate(len - off, this.chunkPoolBlockTime);
            int minSize = chunkPage.remaining();
            if (minSize <= 0) {
                this.chunkPool.deallocate(chunkPage);
                throw new RuntimeException("ByteBuffer remaining is 0");
            }
            chunkPage.put(b, off, b.length);
            chunkPage.flip();
            this.queue.put(new ChannelByteBuffer(socketChannel, chunkPage));
        }
        catch (InterruptedException e) {
            LOGGER.error(e);
        }
        catch (TimeoutException e) {
            LOGGER.error(e);
        }
    }

    public void writeAndFlush(SocketChannel socketChannel, byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        this.write(socketChannel, b, 0, b.length);
    }

    @Override
    public void flush() {
        if (this.closed) {
            throw new RuntimeException("OutputStream has closed");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("OutputStream has closed");
        }
        this.closed = true;
        if (this.chunkPool != null) {
            this.chunkPool.clear();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public ChannelByteBuffer poll() {
        try {
            return this.queue.poll();
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), e);
            return null;
        }
    }
}

