/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import com.fizzed.crux.util.StopWatch;
import com.fizzed.crux.util.TimeDuration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;

public class WaitFor {
    private final Function<Progress, Boolean> condition;

    public WaitFor(Supplier<Boolean> condition) {
        this.condition = c -> (Boolean)condition.get();
    }

    public WaitFor(Function<Progress, Boolean> condition) {
        this.condition = condition;
    }

    public void requireMillis(long timeout, long every) throws InterruptedException, TimeoutException {
        this.require(timeout, every, TimeUnit.MILLISECONDS);
    }

    public void require(long timeout, long every, TimeUnit tu) throws InterruptedException, TimeoutException {
        this.require(new TimeDuration(timeout, tu), new TimeDuration(every, tu));
    }

    public void require(TimeDuration timeout, TimeDuration every) throws InterruptedException, TimeoutException {
        if (!this.await(timeout, every)) {
            throw new TimeoutException("Condition failed within " + timeout);
        }
    }

    public boolean awaitMillis(long timeout, long every) throws InterruptedException {
        return this.await(timeout, every, TimeUnit.MILLISECONDS);
    }

    public boolean await(long timeout, long every, TimeUnit tu) throws InterruptedException {
        return this.await(new TimeDuration(timeout, tu), new TimeDuration(every, tu));
    }

    public boolean await(TimeDuration timeout, TimeDuration every) throws InterruptedException {
        Objects.requireNonNull(timeout, "timeout was null");
        Objects.requireNonNull(every, "every was null");
        if (every.gt(timeout)) {
            throw new IllegalArgumentException("every must be <= timeout");
        }
        StopWatch timer = StopWatch.time(timeout.getUnit());
        int attempt = 1;
        while (timer.elapsedMillis() < (double)timeout.asMillis()) {
            if (this.condition.apply(new Progress(attempt, timeout, every, timer)).booleanValue()) {
                return true;
            }
            Thread.sleep(every.asMillis());
            ++attempt;
        }
        return false;
    }

    public static WaitFor of(Supplier<Boolean> condition) {
        return new WaitFor(condition);
    }

    public static WaitFor of(Function<Progress, Boolean> condition) {
        return new WaitFor(condition);
    }

    public static void requireMillis(Supplier<Boolean> condition, long timeout, long every) throws InterruptedException, TimeoutException {
        new WaitFor(condition).requireMillis(timeout, every);
    }

    public static void require(TimeDuration timeout, TimeDuration every, Function<Progress, Boolean> condition) throws InterruptedException, TimeoutException {
        new WaitFor(condition).require(timeout, every);
    }

    public static void require(Supplier<Boolean> condition, long timeout, long every, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        new WaitFor(condition).require(timeout, every, timeUnit);
    }

    public static class Progress {
        private final int attempt;
        private final TimeDuration timeout;
        private final TimeDuration every;
        private final StopWatch timer;

        public Progress(int attempt, TimeDuration timeout, TimeDuration every, StopWatch timer) {
            this.attempt = attempt;
            this.timeout = timeout;
            this.every = every;
            this.timer = timer;
        }

        public int getAttempt() {
            return this.attempt;
        }

        public TimeDuration getTimeout() {
            return this.timeout;
        }

        public TimeDuration getEvery() {
            return this.every;
        }

        public StopWatch getTimer() {
            return this.timer;
        }
    }
}

