/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import java.util.Objects;
import java.util.UUID;

public class UUIDs {
    private static final long START_EPOCH = -12219292800000L;

    public static UUID fromBytes(byte[] bytes) {
        int i;
        if (bytes == null) {
            return null;
        }
        if (bytes.length != 16) {
            throw new IllegalArgumentException("must be 16 bytes in length");
        }
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(bytes[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(bytes[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    public static byte[] toBytes(String uuid) {
        return UUIDs.toBytes(UUID.fromString(uuid));
    }

    public static byte[] toBytes(UUID uuid) {
        int i;
        if (uuid == null) {
            return null;
        }
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] bytes = new byte[16];
        for (i = 7; i >= 0; --i) {
            bytes[i] = (byte)(msb & 0xFFL);
            msb >>= 8;
        }
        for (i = 15; i >= 8; --i) {
            bytes[i] = (byte)(lsb & 0xFFL);
            lsb >>= 8;
        }
        return bytes;
    }

    public static byte[] toTimeBytes(UUID uuid) {
        int i;
        if (uuid == null) {
            return null;
        }
        if (uuid.version() != 1) {
            throw new IllegalArgumentException("not a time-based uuid");
        }
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] bytes = new byte[16];
        bytes[1] = (byte)(msb & 0xFFL);
        bytes[0] = (byte)((msb >>= 8) & 0xFFL);
        bytes[3] = (byte)((msb >>= 8) & 0xFFL);
        bytes[2] = (byte)((msb >>= 8) & 0xFFL);
        msb >>= 8;
        for (i = 7; i >= 4; --i) {
            bytes[i] = (byte)(msb & 0xFFL);
            msb >>= 8;
        }
        for (i = 15; i >= 8; --i) {
            bytes[i] = (byte)(lsb & 0xFFL);
            lsb >>= 8;
        }
        return bytes;
    }

    public static UUID fromTimeBytes(byte[] bytes) {
        int i;
        if (bytes == null) {
            return null;
        }
        if (bytes.length != 16) {
            throw new IllegalArgumentException("must be 16 bytes in length");
        }
        int version = bytes[0] >> 4 & 0xF;
        if (version != 1) {
            throw new IllegalArgumentException("not a time-based byte array");
        }
        long msb = 0L;
        long lsb = 0L;
        for (i = 4; i < 8; ++i) {
            msb = msb << 8 | (long)(bytes[i] & 0xFF);
        }
        msb = msb << 8 | (long)(bytes[2] & 0xFF);
        msb = msb << 8 | (long)(bytes[3] & 0xFF);
        msb = msb << 8 | (long)(bytes[0] & 0xFF);
        msb = msb << 8 | (long)(bytes[1] & 0xFF);
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(bytes[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    public static long getEpochMillis(UUID uuid) {
        Objects.requireNonNull(uuid, "uuid was null");
        if (uuid.version() != 1) {
            throw new IllegalArgumentException("not a time-based uuid");
        }
        return uuid.timestamp() / 10000L + -12219292800000L;
    }

    public static UUID setEpochMillis(UUID uuid, long epochMillis) {
        Objects.requireNonNull(uuid, "uuid was null");
        if (uuid.version() != 1) {
            throw new IllegalArgumentException("not a time-based uuid");
        }
        long type1Timestamp = (epochMillis - -12219292800000L) * 10000L;
        long msb = UUIDs.buildMSBWithType1Timestamp(type1Timestamp);
        return new UUID(msb, uuid.getLeastSignificantBits());
    }

    public static UUID setTimestamp(UUID uuid, long type1Timestamp) {
        Objects.requireNonNull(uuid, "uuid was null");
        if (uuid.version() != 1) {
            throw new IllegalArgumentException("not a time-based uuid");
        }
        long msb = UUIDs.buildMSBWithType1Timestamp(type1Timestamp);
        return new UUID(msb, uuid.getLeastSignificantBits());
    }

    private static long buildMSBWithType1Timestamp(long type1Timestamp) {
        long msb = 0L;
        msb |= (0xFFFFFFFFL & type1Timestamp) << 32;
        msb |= (0xFFFF00000000L & type1Timestamp) >>> 16;
        msb |= (0xFFF000000000000L & type1Timestamp) >>> 48;
        return msb |= 0x1000L;
    }
}

