/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import com.fizzed.crux.util.UUIDs;
import java.io.Serializable;
import java.util.Arrays;
import java.util.UUID;

public class TimeUUID
implements Serializable,
Comparable<TimeUUID> {
    private final byte[] timeBytes;

    public TimeUUID(byte[] timeBytes) {
        this.timeBytes = timeBytes;
    }

    public byte[] getBytes() {
        return this.timeBytes;
    }

    public long getEpochMillis() {
        return UUIDs.getEpochMillis(this.toUUID());
    }

    public UUID toUUID() {
        return UUIDs.fromTimeBytes(this.timeBytes);
    }

    public static TimeUUID fromUUID(UUID uuid) {
        return new TimeUUID(UUIDs.toTimeBytes(uuid));
    }

    public static TimeUUID fromString(String uuid) {
        return TimeUUID.fromUUID(UUID.fromString(uuid));
    }

    public String toString() {
        return this.toUUID().toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + Arrays.hashCode(this.timeBytes);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeUUID other = (TimeUUID)obj;
        return Arrays.equals(this.timeBytes, other.timeBytes);
    }

    @Override
    public int compareTo(TimeUUID val) {
        for (int i = 0; i < this.timeBytes.length; ++i) {
            int c = Byte.toUnsignedInt(this.timeBytes[i]) - Byte.toUnsignedInt(val.timeBytes[i]);
            if (c < 0) {
                return -1;
            }
            if (c <= 0) continue;
            return 1;
        }
        return 0;
    }
}

