/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import com.fizzed.crux.util.MoreFiles;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;

public class TemporaryPath
implements Closeable {
    private final Path path;

    public TemporaryPath(Path file) {
        Objects.requireNonNull(file, "path was null");
        this.path = file;
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public void close() throws IOException {
        MoreFiles.deleteDirectoryIfExists(this.path);
    }

    public void safeClose() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return this.path.toString();
    }

    public static TemporaryPath tempFile() {
        return TemporaryPath.tempFile("", "");
    }

    public static TemporaryPath tempFile(Path baseDir) {
        return TemporaryPath.tempFile(baseDir, "", "");
    }

    public static TemporaryPath tempFile(String prefix) {
        return TemporaryPath.tempFile(prefix, "");
    }

    public static TemporaryPath tempFile(Path baseDir, String prefix) {
        return TemporaryPath.tempFile(baseDir, prefix, "");
    }

    public static TemporaryPath tempFile(String prefix, String suffix) {
        try {
            Path path = Files.createTempFile(prefix, suffix, new FileAttribute[0]);
            return new TemporaryPath(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static TemporaryPath tempFile(Path baseDir, String prefix, String suffix) {
        try {
            Files.createDirectories(baseDir, new FileAttribute[0]);
            Path path = Files.createTempFile(baseDir, prefix, suffix, new FileAttribute[0]);
            return new TemporaryPath(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static TemporaryPath tempDirectory() {
        return TemporaryPath.tempDirectory("");
    }

    public static TemporaryPath tempDirectory(Path baseDir) {
        return TemporaryPath.tempDirectory(baseDir, "");
    }

    public static TemporaryPath tempDirectory(String prefix) {
        try {
            Path path = Files.createTempDirectory(prefix, new FileAttribute[0]);
            return new TemporaryPath(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static TemporaryPath tempDirectory(Path baseDir, String prefix) {
        try {
            Files.createDirectories(baseDir, new FileAttribute[0]);
            Path path = Files.createTempDirectory(baseDir, prefix, new FileAttribute[0]);
            return new TemporaryPath(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

