/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import com.fizzed.crux.util.SecureCode;
import java.security.SecureRandom;
import java.util.Base64;

public class SecureCodes {
    private static SecureCodes INSTANCE;
    private static final Base64.Decoder decoder;
    private static final Base64.Encoder encoder;
    private final SecureRandom random = new SecureRandom();

    public SecureCodes() {
        this(new SecureRandom());
    }

    public SecureCodes(SecureRandom random) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecureCodes getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Class<SecureCodes> clazz = SecureCodes.class;
        synchronized (SecureCodes.class) {
            INSTANCE = new SecureCodes();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public SecureCode code(int byteLength) {
        byte[] bytes = new byte[byteLength];
        this.random.nextBytes(bytes);
        return new SecureCode(bytes);
    }

    public SecureCode code16() {
        return this.code(16);
    }

    public SecureCode code24() {
        return this.code(24);
    }

    public SecureCode code32() {
        return this.code(32);
    }

    public SecureCode code36() {
        return this.code(36);
    }

    public SecureCode code48() {
        return this.code(48);
    }

    public SecureCode code60() {
        return this.code(60);
    }

    public SecureCode code64() {
        return this.code(64);
    }

    public SecureCode code128() {
        return this.code(128);
    }

    public SecureCode code256() {
        return this.code(256);
    }

    public SecureCode code512() {
        return this.code(512);
    }

    public static String encode(byte[] bytes) {
        String encoded = encoder.encodeToString(bytes);
        if (encoded.charAt(encoded.length() - 2) == '=') {
            return encoded.substring(0, encoded.length() - 2);
        }
        if (encoded.charAt(encoded.length() - 1) == '=') {
            return encoded.substring(0, encoded.length() - 1);
        }
        return encoded;
    }

    public static byte[] decode(String string) throws IllegalArgumentException {
        return decoder.decode(string);
    }

    static {
        decoder = Base64.getUrlDecoder();
        encoder = Base64.getUrlEncoder();
    }
}

