/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import com.fizzed.crux.util.Size2D;
import java.util.Objects;

public class Rect2D {
    private final double x;
    private final double y;
    private final double width;
    private final double height;

    public Rect2D(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rect2D(double x, double y, Size2D size) {
        Objects.requireNonNull(size, "size was null");
        this.x = x;
        this.y = y;
        this.width = size.getWidth();
        this.height = size.getHeight();
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public Rect2D plusX(double x) {
        return this.plus(x, 0.0, 0.0, 0.0);
    }

    public Rect2D plusY(double y) {
        return this.plus(0.0, y, 0.0, 0.0);
    }

    public Rect2D plusWidth(double width) {
        return this.plus(0.0, 0.0, width, 0.0);
    }

    public Rect2D plusHeight(double height) {
        return this.plus(0.0, 0.0, 0.0, height);
    }

    public Rect2D plus(Rect2D rect) {
        if (rect == null) {
            return this;
        }
        return this.plus(rect.x, rect.y, rect.width, rect.height);
    }

    public Rect2D plus(double x, double y, double width, double height) {
        return new Rect2D(this.x + x, this.y + y, this.width + width, this.height + height);
    }

    public int ceilX() {
        return (int)Math.ceil(this.x);
    }

    public int ceilY() {
        return (int)Math.ceil(this.y);
    }

    public int ceilWidth() {
        return (int)Math.ceil(this.width);
    }

    public int ceilHeight() {
        return (int)Math.ceil(this.height);
    }

    public int floorX() {
        return (int)Math.floor(this.x);
    }

    public int floorY() {
        return (int)Math.floor(this.y);
    }

    public int floorWidth() {
        return (int)Math.floor(this.width);
    }

    public int floorHeight() {
        return (int)Math.floor(this.height);
    }
}

