/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import com.fizzed.crux.util.MaybeStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;

public class MoreObjects {
    public static boolean isTrue(Boolean value) {
        return value != null && value != false;
    }

    public static <T> boolean in(T value, T ... values) {
        if (values == null) {
            throw new IllegalArgumentException("values was null");
        }
        for (T v : values) {
            if (!Objects.equals(v, value)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean in(T value, Iterable<T> values) {
        if (values == null) {
            throw new IllegalArgumentException("values was null");
        }
        for (T v : values) {
            if (!Objects.equals(v, value)) continue;
            return true;
        }
        return false;
    }

    public static <T> Iterable<T> iterable(T[] values) {
        return new MaybeStream.ArrayIterable<T>(values);
    }

    public static <T> Iterable<T> iterable(Iterable<T> values) {
        if (values == null) {
            return new MaybeStream.ArrayIterable(null);
        }
        return values;
    }

    public static int size(Object[] values) {
        return values != null ? values.length : 0;
    }

    public static int size(Collection<?> values) {
        return values != null ? values.size() : 0;
    }

    public static int size(Map<?, ?> map) {
        return map != null ? map.size() : 0;
    }

    public static <T> T first(T[] values) {
        return values != null && values.length > 0 ? (T)values[0] : null;
    }

    public static <T> T first(Iterable<T> values) {
        if (values == null) {
            return null;
        }
        if (values instanceof List) {
            List l = (List)values;
            return l.isEmpty() ? null : (T)l.get(0);
        }
        if (values instanceof SortedSet) {
            SortedSet s = (SortedSet)values;
            return (T)s.first();
        }
        Iterator<T> it = values.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public static <T> T last(T[] values) {
        return values != null && values.length > 0 ? (T)values[values.length - 1] : null;
    }

    public static <T> T last(Iterable<T> values) {
        if (values == null) {
            return null;
        }
        if (values instanceof List) {
            List l = (List)values;
            return l.isEmpty() ? null : (T)l.get(l.size() - 1);
        }
        if (values instanceof SortedSet) {
            SortedSet s = (SortedSet)values;
            return (T)s.last();
        }
        Iterator<T> it = values.iterator();
        T last = null;
        while (it.hasNext()) {
            last = it.next();
        }
        return last;
    }

    public static <T> boolean isEmpty(T[] values) {
        return values == null || values.length == 0;
    }

    public static boolean isEmpty(Collection<?> values) {
        return values == null || values.isEmpty();
    }

    public static boolean isEmpty(Iterable<?> values) {
        return values == null || !values.iterator().hasNext();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(CharSequence chars) {
        return chars == null || chars.length() == 0;
    }

    public static boolean isBlank(CharSequence chars) {
        if (chars == null || chars.length() == 0) {
            return true;
        }
        for (int i = 0; i < chars.length(); ++i) {
            if (chars.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }
}

