/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import com.fizzed.crux.util.Maybe;
import com.fizzed.crux.util.MoreObjects;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class MaybeStream<T>
implements Iterable<T> {
    private final Iterable<T> values;

    protected MaybeStream(Iterable<T> values) {
        this.values = values;
    }

    public Stream<T> get() {
        if (this.values == null) {
            throw new NoSuchElementException("No values present");
        }
        return this.jvmStream();
    }

    public Stream<T> jvmStream() {
        if (this.values == null) {
            return Stream.empty();
        }
        if (this.values instanceof Collection) {
            return ((Collection)this.values).stream();
        }
        return StreamSupport.stream(this.values.spliterator(), false);
    }

    @Deprecated
    public Stream<T> stream() {
        return this.jvmStream();
    }

    public Maybe<T> first() {
        return Maybe.of(MoreObjects.first(this.values));
    }

    public Maybe<T> last() {
        return Maybe.of(MoreObjects.last(this.values));
    }

    @Override
    public Iterator<T> iterator() {
        if (this.values == null) {
            return new ArrayIterator(null);
        }
        if (this.values instanceof Collection) {
            return ((Collection)this.values).iterator();
        }
        return this.values.iterator();
    }

    public void forEach(BiConsumer<T, Integer> consumer) {
        if (this.values != null) {
            IterableIter<T> iter = new IterableIter<T>(this.values);
            iter.forEach(consumer);
        }
    }

    public boolean isPresent() {
        return this.values != null;
    }

    public boolean isAbsent() {
        return this.values == null;
    }

    public static <T> MaybeStream<T> empty() {
        return new MaybeStream<T>(null);
    }

    public static <T> MaybeStream<T> of(T[] values) {
        if (values == null) {
            return MaybeStream.empty();
        }
        return MaybeStream.maybeStream(new ArrayIterable<T>(values));
    }

    public static <T> MaybeStream<T> of(Iterable<T> values) {
        return MaybeStream.maybeStream(values);
    }

    public static <T> MaybeStream<T> maybeStream(T[] values) {
        return MaybeStream.of(values);
    }

    public static <T> MaybeStream<T> maybeStream(Iterable<T> value) {
        return new MaybeStream<T>(value);
    }

    public static class IterableIter<V>
    implements Iter<V> {
        private final Iterable<V> values;

        public IterableIter(Iterable<V> values) {
            this.values = values;
        }

        @Override
        public void forEach(BiConsumer<V, Integer> consumer) {
            if (this.values == null) {
                return;
            }
            Iterator<V> iterator = this.values.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                V value = iterator.next();
                consumer.accept(value, i);
                ++i;
            }
        }
    }

    public static interface Iter<V> {
        public void forEach(BiConsumer<V, Integer> var1);
    }

    public static class ArrayIterator<V>
    implements Iterator<V> {
        private final V[] values;
        private int index;

        public ArrayIterator(V[] values) {
            this.values = values;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.values != null && this.index < this.values.length;
        }

        @Override
        public V next() {
            if (this.values == null) {
                return null;
            }
            V value = this.values[this.index];
            ++this.index;
            return value;
        }
    }

    public static class ArrayIterable<V>
    implements Iterable<V> {
        private final V[] values;

        public ArrayIterable(V[] values) {
            this.values = values;
        }

        @Override
        public Iterator<V> iterator() {
            return new ArrayIterator<V>(this.values);
        }
    }
}

