/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import com.fizzed.crux.util.MaybeStream;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Maybe<T> {
    private T value;

    public Maybe(T value) {
        this.value = value;
    }

    public T get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public void set(T value) {
        this.value = value;
    }

    public T orNull() {
        return this.isPresent() ? (T)this.value : null;
    }

    public T orElse(T defaultValue) {
        return this.isPresent() ? this.value : defaultValue;
    }

    public T orGet(Supplier<T> defaultSupplier) {
        Objects.requireNonNull(defaultSupplier, "supplier was null");
        return this.isPresent() ? this.value : defaultSupplier.get();
    }

    public <X extends Throwable> T orThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.value == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public boolean isAbsent() {
        return this.value == null;
    }

    public boolean match(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate was null");
        return this.value != null && predicate.test(this.value);
    }

    public Maybe<T> ifPresent(Consumer<? super T> consumer) {
        if (this.value != null) {
            consumer.accept(this.value);
        }
        return this;
    }

    public Maybe<T> ifAbsent(Runnable runnable) {
        if (this.value == null) {
            runnable.run();
        }
        return this;
    }

    public <U> Maybe<U> typed(Class<? super U> type) {
        Objects.requireNonNull(type, "type was null");
        if (this.value != null && type.isInstance(this.value)) {
            return Maybe.of(this.value);
        }
        return Maybe.empty();
    }

    public Maybe<T> filter(Predicate<? super T> predicate) {
        if (this.value != null) {
            if (predicate.test(this.value)) {
                return this;
            }
            return Maybe.empty();
        }
        return this;
    }

    public <U> Maybe<U> map(Function<? super T, ? extends U> mapper) {
        if (this.value != null) {
            return Maybe.of(mapper.apply(this.value));
        }
        return Maybe.empty();
    }

    public <U> Stream<U> jvmStream(Function<? super T, ? extends Iterable<U>> mapper) {
        return this.stream(mapper).stream();
    }

    @Deprecated
    public <U> Stream<U> mapStream(Function<? super T, ? extends Iterable<U>> mapper) {
        return this.jvmStream(mapper);
    }

    public <U> MaybeStream<U> stream(Function<? super T, ? extends Iterable<U>> mapper) {
        if (this.value != null) {
            return MaybeStream.of(mapper.apply(this.value));
        }
        return MaybeStream.empty();
    }

    public <U> Maybe<U> flatMap(Function<? super T, Maybe<U>> mapper) {
        if (this.value != null) {
            return mapper.apply(this.value);
        }
        return Maybe.empty();
    }

    public <U> Maybe<U> jvmFlatMap(Function<? super T, Optional<U>> mapper) {
        if (this.value != null) {
            return Maybe.of(mapper.apply(this.value));
        }
        return Maybe.empty();
    }

    @Deprecated
    public <U> Maybe<U> optMap(Function<? super T, Optional<U>> mapper) {
        return this.jvmFlatMap(mapper);
    }

    public Optional<T> jvmOptional() {
        return Optional.ofNullable(this.value);
    }

    @Deprecated
    public Optional<T> toOptional() {
        return this.jvmOptional();
    }

    public static <T> Maybe<T> empty() {
        return new Maybe<Object>(null);
    }

    public static <T> Maybe<T> of(T value) {
        return Maybe.maybe(value);
    }

    public static <T> Maybe<T> maybe(T value) {
        return new Maybe<T>(value);
    }

    public static <T> Maybe<T> of(Optional<T> valueOptional) {
        return Maybe.maybe(valueOptional);
    }

    public static <T> Maybe<T> maybe(Optional<T> valueOptional) {
        if (valueOptional == null) {
            return Maybe.empty();
        }
        return new Maybe<Object>(valueOptional.orElse(null));
    }

    public String toString() {
        return this.value != null ? this.value.toString() : null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Maybe)) {
            return false;
        }
        Maybe other = (Maybe)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }
}

