/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentBooleanLatch {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition trueCondition = this.lock.newCondition();
    private final Condition falseCondition = this.lock.newCondition();
    private boolean value;

    public ConcurrentBooleanLatch() {
        this(true);
    }

    public ConcurrentBooleanLatch(boolean initialValue) {
        this.value = initialValue;
    }

    public boolean get() {
        this.lock.lock();
        try {
            boolean bl = this.value;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void set(boolean newValue) {
        this.lock.lock();
        try {
            this.value = newValue;
            if (this.value) {
                this.trueCondition.signal();
            } else {
                this.falseCondition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void await(boolean value) throws InterruptedException {
        this.await(value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(boolean value, Runnable willWait) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            Condition condition;
            Condition condition2 = condition = value ? this.trueCondition : this.falseCondition;
            while (value != this.value) {
                if (willWait != null) {
                    willWait.run();
                }
                condition.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean await(boolean value, long timeout, TimeUnit tu) throws InterruptedException {
        return this.await(value, timeout, tu, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(boolean value, long timeout, TimeUnit tu, Runnable willWait) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            Condition condition;
            Condition condition2 = condition = value ? this.trueCondition : this.falseCondition;
            while (value != this.value) {
                if (willWait != null) {
                    willWait.run();
                }
                if (condition.await(timeout, tu)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

