/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class BindingPropertyMap<A> {
    public static final Function<String, String> STRING_CONVERTER = s -> s;
    public static final Function<String, Boolean> BOOLEAN_CONVERTER = s -> {
        if (s == null) {
            return null;
        }
        if (s.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (s.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Invalid boolean (only true or false)");
    };
    public static final Function<String, Integer> INTEGER_CONVERTER = s -> s != null ? Integer.valueOf(s) : null;
    public static final Function<String, Long> LONG_CONVERTER = s -> s != null ? Long.valueOf(s) : null;
    public static final Function<String, Path> PATH_CONVERTER = s -> s != null ? Paths.get(s, new String[0]) : null;
    public static final Function<String, File> FILE_CONVERTER = s -> s != null ? new File((String)s) : null;
    public static final Function<String, URI> URI_CONVERTER = s -> s != null ? URI.create(s) : null;
    public static final Function<String, URL> URL_CONVERTER = s -> {
        if (s == null) {
            return null;
        }
        try {
            return new URL((String)s);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    };
    private final Map<String, Property<A, ?>> map = new LinkedHashMap();

    public BindingPropertyMap<A> bindString(String key, BiConsumer<A, String> setter) {
        this.map.put(key, new Property<A, String>(String.class, setter, STRING_CONVERTER));
        return this;
    }

    public BindingPropertyMap<A> bindBoolean(String key, BiConsumer<A, Boolean> setter) {
        this.map.put(key, new Property<A, Boolean>(Boolean.class, setter, BOOLEAN_CONVERTER));
        return this;
    }

    public BindingPropertyMap<A> bindInteger(String key, BiConsumer<A, Integer> setter) {
        this.map.put(key, new Property<A, Integer>(Integer.class, setter, INTEGER_CONVERTER));
        return this;
    }

    public BindingPropertyMap<A> bindLong(String key, BiConsumer<A, Long> setter) {
        this.map.put(key, new Property<A, Long>(Long.class, setter, LONG_CONVERTER));
        return this;
    }

    public BindingPropertyMap<A> bindPath(String key, BiConsumer<A, Path> setter) {
        this.map.put(key, new Property<A, Path>(Path.class, setter, PATH_CONVERTER));
        return this;
    }

    public BindingPropertyMap<A> bindFile(String key, BiConsumer<A, File> setter) {
        this.map.put(key, new Property<A, File>(File.class, setter, FILE_CONVERTER));
        return this;
    }

    public BindingPropertyMap<A> bindURI(String key, BiConsumer<A, URI> setter) {
        this.map.put(key, new Property<A, URI>(URI.class, setter, URI_CONVERTER));
        return this;
    }

    public BindingPropertyMap<A> bindURL(String key, BiConsumer<A, URL> setter) {
        this.map.put(key, new Property<A, URL>(URL.class, setter, URL_CONVERTER));
        return this;
    }

    public <T> BindingPropertyMap<A> bindType(String key, BiConsumer<A, T> setter, Class<T> type, Function<String, T> converter) {
        this.map.put(key, new Property<A, T>(type, setter, converter));
        return this;
    }

    public Set<String> getKeys() {
        return this.map.keySet();
    }

    public boolean hasKey(String key) {
        return this.map.containsKey(key);
    }

    public void set(A instance, String key, Object value) {
        this.set(instance, key, value, false);
    }

    public void set(A instance, String key, Object value, boolean skipUnknownKeys) {
        Objects.requireNonNull(instance, "instance was null");
        Objects.requireNonNull(key, "key was null");
        Property<A, ?> property = this.map.get(key);
        if (property == null) {
            if (skipUnknownKeys) {
                return;
            }
            throw new IllegalArgumentException("Property '" + key + "' is not recognized for " + instance.getClass().getCanonicalName() + " (available are " + this.map.keySet() + ")");
        }
        try {
            property.set(instance, value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Property '" + key + "' could not be converted. " + e.getMessage(), e.getCause());
        }
    }

    public void setAll(A instance, Properties properties) {
        this.setAll(instance, properties, false);
    }

    public void setAll(A instance, Properties properties, boolean skipUnknownKeys) {
        if (properties == null) {
            return;
        }
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.set(instance, key.toString(), value, skipUnknownKeys)));
    }

    public void setAll(A instance, Map<String, ?> values) {
        this.setAll(instance, values, false);
    }

    public void setAll(A instance, Map<String, ?> values, boolean skipUnknownKeys) {
        if (values == null) {
            return;
        }
        values.forEach((key, value) -> this.set(instance, (String)key, value, skipUnknownKeys));
    }

    public class Property<A, T> {
        private final Class<T> type;
        private final BiConsumer<A, T> setter;
        private final Function<String, T> converter;

        public Property(Class<T> type, BiConsumer<A, T> setter, Function<String, T> converter) {
            this.type = type;
            this.setter = setter;
            this.converter = converter;
        }

        public void set(A instance, Object value) {
            Object target;
            if (value == null || this.type.isInstance(value)) {
                target = value;
            } else {
                String s = Objects.toString(value, null);
                try {
                    target = this.converter.apply(s);
                }
                catch (Throwable t) {
                    throw new IllegalArgumentException("Unable to convert '" + s + "' to " + this.type.getCanonicalName());
                }
            }
            this.setter.accept(instance, target);
        }
    }
}

