/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import java.nio.charset.StandardCharsets;

public class Base32 {
    private static final int MASK_2BITS = 3;
    private static final int MASK_3BITS = 7;
    private static final int MASK_4BITS = 15;
    private static final int MASK_5BITS = 31;
    private static final byte PAD = 61;
    private static final int OFFSET_OF_2 = 24;
    private static final byte[] UPPER_CHARS = Base32.upperAlphabets();
    private static final byte[] LOWER_CHARS = Base32.lowerAlphabets();

    private static byte[] internalEncode(byte[] encodeAlphabet, byte[] src, boolean padded) {
        int num5bytes = src.length / 5;
        int remainder = src.length % 5;
        if (remainder == 0) {
            byte[] dest = new byte[num5bytes * 8];
            int s = 0;
            int d = 0;
            while (s < src.length) {
                Base32.encode5bytes(encodeAlphabet, src, s, dest, d);
                s += 5;
                d += 8;
            }
            return dest;
        }
        int length = (num5bytes + 1) * 8;
        if (!padded) {
            switch (remainder) {
                case 1: {
                    length -= 6;
                    break;
                }
                case 2: {
                    length -= 4;
                    break;
                }
                case 3: {
                    length -= 3;
                    break;
                }
                case 4: {
                    --length;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        byte[] dest = new byte[length];
        int s = 0;
        int d = 0;
        while (s < src.length - remainder) {
            Base32.encode5bytes(encodeAlphabet, src, s, dest, d);
            s += 5;
            d += 8;
        }
        switch (remainder) {
            case 1: {
                Base32.encode1byte(encodeAlphabet, src, s, dest, d, padded);
                break;
            }
            case 2: {
                Base32.encode2bytes(encodeAlphabet, src, s, dest, d, padded);
                break;
            }
            case 3: {
                Base32.encode3bytes(encodeAlphabet, src, s, dest, d, padded);
                break;
            }
            case 4: {
                Base32.encode4bytes(encodeAlphabet, src, s, dest, d, padded);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return dest;
    }

    private static void encode5bytes(byte[] encodeAlphabet, byte[] src, int s, byte[] dest, int d) {
        int n = d++;
        byte p = src[s++];
        dest[n] = encodeAlphabet[p >>> 3 & 0x1F];
        int n2 = d++;
        int n3 = (p & 7) << 2;
        p = src[s++];
        dest[n2] = encodeAlphabet[n3 | p >>> 6 & 3];
        dest[d++] = encodeAlphabet[p >>> 1 & 0x1F];
        int n4 = d++;
        int n5 = (p & 1) << 4;
        p = src[s++];
        dest[n4] = encodeAlphabet[n5 | p >>> 4 & 0xF];
        int n6 = d++;
        int n7 = (p & 0xF) << 1;
        p = src[s++];
        dest[n6] = encodeAlphabet[n7 | p >>> 7 & 1];
        dest[d++] = encodeAlphabet[p >>> 2 & 0x1F];
        int n8 = d++;
        int n9 = (p & 3) << 3;
        p = src[s];
        dest[n8] = encodeAlphabet[n9 | p >>> 5 & 7];
        dest[d] = encodeAlphabet[p & 0x1F];
    }

    private static void encode4bytes(byte[] encodeAlphabet, byte[] src, int s, byte[] dest, int d, boolean padding) {
        int n = d++;
        byte p = src[s++];
        dest[n] = encodeAlphabet[p >>> 3 & 0x1F];
        int n2 = d++;
        int n3 = (p & 7) << 2;
        p = src[s++];
        dest[n2] = encodeAlphabet[n3 | p >>> 6 & 3];
        dest[d++] = encodeAlphabet[p >>> 1 & 0x1F];
        int n4 = d++;
        int n5 = (p & 1) << 4;
        p = src[s++];
        dest[n4] = encodeAlphabet[n5 | p >>> 4 & 0xF];
        int n6 = d++;
        int n7 = (p & 0xF) << 1;
        p = src[s];
        dest[n6] = encodeAlphabet[n7 | p >>> 7 & 1];
        dest[d++] = encodeAlphabet[p >>> 2 & 0x1F];
        dest[d++] = encodeAlphabet[(p & 3) << 3];
        if (padding) {
            dest[d] = 61;
        }
    }

    private static void encode3bytes(byte[] encodeAlphabet, byte[] src, int s, byte[] dest, int d, boolean padding) {
        int n = d++;
        byte p = src[s++];
        dest[n] = encodeAlphabet[p >>> 3 & 0x1F];
        int n2 = d++;
        int n3 = (p & 7) << 2;
        p = src[s++];
        dest[n2] = encodeAlphabet[n3 | p >>> 6 & 3];
        dest[d++] = encodeAlphabet[p >>> 1 & 0x1F];
        int n4 = d++;
        int n5 = (p & 1) << 4;
        p = src[s];
        dest[n4] = encodeAlphabet[n5 | p >>> 4 & 0xF];
        dest[d++] = encodeAlphabet[(p & 0xF) << 1];
        if (padding) {
            for (int i = 0; i < 3; ++i) {
                dest[d++] = 61;
            }
        }
    }

    private static void encode2bytes(byte[] encodeAlphabet, byte[] src, int s, byte[] dest, int d, boolean padding) {
        int n = d++;
        byte p = src[s++];
        dest[n] = encodeAlphabet[p >>> 3 & 0x1F];
        int n2 = d++;
        int n3 = (p & 7) << 2;
        p = src[s];
        dest[n2] = encodeAlphabet[n3 | p >>> 6 & 3];
        dest[d++] = encodeAlphabet[p >>> 1 & 0x1F];
        dest[d++] = encodeAlphabet[(p & 1) << 4];
        if (padding) {
            for (int i = 0; i < 4; ++i) {
                dest[d++] = 61;
            }
        }
    }

    private static void encode1byte(byte[] encodeAlphabet, byte[] src, int s, byte[] dest, int d, boolean padding) {
        int n = d++;
        byte p = src[s];
        dest[n] = encodeAlphabet[p >>> 3 & 0x1F];
        dest[d++] = encodeAlphabet[(p & 7) << 2];
        if (padding) {
            for (int i = 0; i < 6; ++i) {
                dest[d++] = 61;
            }
        }
    }

    private static void decode5bytes(byte[] src, int s, byte[] dest, int d) {
        int p = 0;
        int n = d++;
        int n2 = s++;
        p = Base32.pos(src[s++]);
        dest[n] = (byte)(Base32.pos(src[n2]) << 3 | p >>> 2 & 7);
        int n3 = d++;
        int n4 = (p & 3) << 6 | Base32.pos(src[s++]) << 1;
        p = Base32.pos(src[s++]);
        dest[n3] = (byte)(n4 | p >>> 4 & 1);
        int n5 = d++;
        int n6 = (p & 0xF) << 4;
        p = Base32.pos(src[s++]);
        dest[n5] = (byte)(n6 | p >>> 1 & 0xF);
        int n7 = d++;
        int n8 = (p & 1) << 7 | Base32.pos(src[s++]) << 2;
        p = Base32.pos(src[s++]);
        dest[n7] = (byte)(n8 | p >>> 3 & 3);
        dest[d] = (byte)((p & 7) << 5 | Base32.pos(src[s]));
    }

    private static void decode1to4bytes(int n, byte[] src, int s, byte[] dest, int d) {
        int p = 0;
        int n2 = d++;
        int n3 = s++;
        p = Base32.pos(src[s++]);
        dest[n2] = (byte)(Base32.pos(src[n3]) << 3 | p >>> 2 & 7);
        if (n == 1) {
            Base32.sanityCheckLastPos(p, 3);
            return;
        }
        int n4 = d++;
        int n5 = (p & 3) << 6 | Base32.pos(src[s++]) << 1;
        p = Base32.pos(src[s++]);
        dest[n4] = (byte)(n5 | p >>> 4 & 1);
        if (n == 2) {
            Base32.sanityCheckLastPos(p, 15);
            return;
        }
        int n6 = d++;
        int n7 = (p & 0xF) << 4;
        p = Base32.pos(src[s++]);
        dest[n6] = (byte)(n7 | p >>> 1 & 0xF);
        if (n == 3) {
            Base32.sanityCheckLastPos(p, 1);
            return;
        }
        int n8 = (p & 1) << 7 | Base32.pos(src[s++]) << 2;
        p = Base32.pos(src[s]);
        dest[d] = (byte)(n8 | p >>> 3 & 3);
        Base32.sanityCheckLastPos(p, 7);
    }

    private static byte[] internalDecode(byte[] src, int l) {
        int d;
        int fq;
        int possiblePads = 8 - l % 8;
        int pads = possiblePads != 8 ? possiblePads : 0;
        int length = l + pads;
        for (int last = l - 1; pads < 6 && last > -1 && src[last] == 61; --last, ++pads) {
        }
        switch (pads) {
            case 0: {
                fq = 5;
                break;
            }
            case 1: {
                fq = 4;
                break;
            }
            case 3: {
                fq = 3;
                break;
            }
            case 4: {
                fq = 2;
                break;
            }
            case 6: {
                fq = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid number of paddings " + pads);
            }
        }
        byte[] dest = new byte[length / 8 * 5 - (5 - fq)];
        int s = 0;
        for (d = 0; d < dest.length - fq % 5; d += 5) {
            Base32.decode5bytes(src, s, dest, d);
            s += 8;
        }
        if (fq < 5) {
            Base32.decode1to4bytes(fq, src, s, dest, d);
        }
        return dest;
    }

    private static int pos(byte in) {
        byte pos = LazyHolder.DECODED[in];
        if (pos > -1) {
            return pos;
        }
        throw new IllegalArgumentException("Invalid base 32 character: '" + (char)in + "'");
    }

    public static String encode(byte[] bytes) {
        return Base32.encode(bytes, true, false);
    }

    public static String encode(byte[] bytes, boolean padded) {
        return Base32.encode(bytes, padded, false);
    }

    public static String encode(byte[] bytes, boolean padded, boolean lower) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return "";
        }
        byte[] encoded = Base32.internalEncode(lower ? LOWER_CHARS : UPPER_CHARS, bytes, padded);
        return new String(encoded, StandardCharsets.ISO_8859_1);
    }

    public static byte[] decode(String b32) {
        if (b32 == null) {
            return null;
        }
        if (b32.length() == 0) {
            return new byte[0];
        }
        byte[] buf = b32.getBytes(StandardCharsets.ISO_8859_1);
        return Base32.internalDecode(buf, buf.length);
    }

    private static byte[] upperAlphabets() {
        return Base32.toBytesDirect("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567");
    }

    private static byte[] lowerAlphabets() {
        return Base32.toBytesDirect("abcdefghijklmnopqrstuvwxyz234567");
    }

    private static byte[] toBytesDirect(String singleOctets) {
        char[] src = singleOctets.toCharArray();
        byte[] dest = new byte[src.length];
        for (int i = 0; i < dest.length; ++i) {
            char c = src[i];
            if (c > '\u007f') {
                throw new IllegalArgumentException("Invalid character found at position " + i + " for " + singleOctets);
            }
            dest[i] = (byte)c;
        }
        return dest;
    }

    private static void sanityCheckLastPos(int pos, int mask) {
        if ((pos & mask) != 0) {
            throw new IllegalArgumentException("Invalid last non-pad character detected");
        }
    }

    private static class LazyHolder {
        private static final byte[] DECODED = LazyHolder.decodeTable();

        private LazyHolder() {
        }

        private static byte[] decodeTable() {
            byte[] dest = new byte[123];
            for (int i = 0; i <= 122; ++i) {
                dest[i] = i >= 65 && i <= 90 ? (int)(i - 65) : (i >= 50 && i <= 55 ? (int)(i - 24) : (i >= 97 && i <= 122 ? (int)(i - 97) : -1));
            }
            return dest;
        }
    }
}

