/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.util;

import com.deepoove.poi.data.style.BorderStyle;
import com.deepoove.poi.data.style.CellStyle;
import com.deepoove.poi.data.style.ParagraphStyle;
import com.deepoove.poi.data.style.RowStyle;
import com.deepoove.poi.data.style.Style;
import com.deepoove.poi.data.style.TableStyle;
import com.deepoove.poi.util.TableTools;
import com.deepoove.poi.util.UnitUtils;
import com.deepoove.poi.xwpf.CssRgb;
import com.deepoove.poi.xwpf.XWPFHighlightColor;
import com.deepoove.poi.xwpf.XWPFOnOff;
import com.deepoove.poi.xwpf.XWPFShadingPattern;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.LineSpacingRule;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.StringEnumAbstractBase;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHeight;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHighlight;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTInd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPBdr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTParaRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTrPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTUnderline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHeightRule;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHexColorAuto;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHexColorRGB;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHighlightColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STUnderline;

public final class StyleUtils {
    public static void styleRun(XWPFRun run, Style style) {
        String vertAlign;
        int point;
        UnderlinePatterns underlinePatern;
        Boolean strike;
        Boolean italic;
        Boolean bold;
        XWPFHighlightColor highlightColor;
        String westernFontFamily;
        String fontFamily;
        double fontSize;
        if (null == run || null == style) {
            return;
        }
        CTRPr pr = StyleUtils.getRunProperties(run);
        String color = style.getColor();
        if (StringUtils.isNotBlank((CharSequence)color)) {
            CTColor ctColor = pr.isSetColor() ? pr.getColor() : pr.addNewColor();
            ctColor.setVal((Object)color);
            if (ctColor.isSetThemeColor()) {
                ctColor.unsetThemeColor();
            }
        }
        if (0.0 != (fontSize = style.getFontSize()) && -1.0 != fontSize) {
            BigDecimal bd = BigDecimal.valueOf(fontSize);
            CTHpsMeasure ctSize = pr.isSetSz() ? pr.getSz() : pr.addNewSz();
            ctSize.setVal(bd.multiply(BigDecimal.valueOf(2L)).setScale(0, RoundingMode.HALF_UP).toBigInteger());
        }
        if (StringUtils.isNotBlank((CharSequence)(fontFamily = style.getFontFamily()))) {
            run.setFontFamily(fontFamily, XWPFRun.FontCharRange.eastAsia);
            run.setFontFamily(fontFamily, XWPFRun.FontCharRange.ascii);
            run.setFontFamily(fontFamily, XWPFRun.FontCharRange.hAnsi);
            run.setFontFamily(fontFamily, XWPFRun.FontCharRange.cs);
        }
        if (StringUtils.isNotBlank((CharSequence)(westernFontFamily = style.getWesternFontFamily()))) {
            run.setFontFamily(westernFontFamily, XWPFRun.FontCharRange.ascii);
            run.setFontFamily(westernFontFamily, XWPFRun.FontCharRange.hAnsi);
            run.setFontFamily(westernFontFamily, XWPFRun.FontCharRange.cs);
        }
        if (null != (highlightColor = style.getHighlightColor())) {
            CTHighlight highlight = pr.isSetHighlight() ? pr.getHighlight() : pr.addNewHighlight();
            highlight.setVal(STHighlightColor.Enum.forInt((int)highlightColor.getValue()));
        }
        if (null != (bold = style.isBold())) {
            run.setBold(bold.booleanValue());
        }
        if (null != (italic = style.isItalic())) {
            run.setItalic(italic.booleanValue());
        }
        if (null != (strike = style.isStrike())) {
            run.setStrikeThrough(strike.booleanValue());
        }
        if (null != (underlinePatern = style.getUnderlinePatterns())) {
            run.setUnderline(underlinePatern);
            if (null != style.getUnderlineColor()) {
                run.setUnderlineColor(style.getUnderlineColor());
            }
        }
        if (0 != (point = style.getCharacterSpacing()) && -1 != point) {
            run.setCharacterSpacing(UnitUtils.point2Twips(point));
        }
        if (StringUtils.isNotBlank((CharSequence)(vertAlign = style.getVertAlign()))) {
            run.setVerticalAlignment(vertAlign);
        }
    }

    public static void styleRun(XWPFRun dest, XWPFRun src) {
        CTRPr pr;
        BigDecimal fontSize;
        if (null == dest || null == src) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)src.getStyle())) {
            dest.setStyle(src.getStyle());
        }
        if (Boolean.TRUE.equals(src.isBold())) {
            dest.setBold(src.isBold());
        }
        if (StringUtils.isNotBlank((CharSequence)src.getColor())) {
            dest.setColor(src.getColor());
        }
        if (0 != src.getCharacterSpacing()) {
            dest.setCharacterSpacing(src.getCharacterSpacing());
        }
        if (StringUtils.isNotBlank((CharSequence)src.getFontFamily(XWPFRun.FontCharRange.ascii))) {
            dest.setFontFamily(src.getFontFamily(), XWPFRun.FontCharRange.ascii);
        }
        if (StringUtils.isNotBlank((CharSequence)src.getFontFamily(XWPFRun.FontCharRange.eastAsia))) {
            dest.setFontFamily(src.getFontFamily(), XWPFRun.FontCharRange.eastAsia);
        }
        if (StringUtils.isNotBlank((CharSequence)src.getFontFamily(XWPFRun.FontCharRange.hAnsi))) {
            dest.setFontFamily(src.getFontFamily(), XWPFRun.FontCharRange.hAnsi);
        }
        if (StringUtils.isNotBlank((CharSequence)src.getFontFamily(XWPFRun.FontCharRange.cs))) {
            dest.setFontFamily(src.getFontFamily(), XWPFRun.FontCharRange.cs);
        }
        BigDecimal bigDecimal = fontSize = (pr = src.getCTR().getRPr()) != null && pr.isSetSz() ? new BigDecimal(pr.getSz().getVal()).divide(BigDecimal.valueOf(2L)).setScale(1, RoundingMode.HALF_UP) : null;
        if (null != fontSize) {
            CTRPr destPr = StyleUtils.getRunProperties(dest);
            CTHpsMeasure ctSize = destPr.isSetSz() ? destPr.getSz() : destPr.addNewSz();
            ctSize.setVal(fontSize.multiply(BigDecimal.valueOf(2L)).setScale(0, RoundingMode.HALF_UP).toBigInteger());
        }
        if (Boolean.TRUE.equals(src.isItalic())) {
            dest.setItalic(src.isItalic());
        }
        if (Boolean.TRUE.equals(src.isStrikeThrough())) {
            dest.setStrikeThrough(src.isStrikeThrough());
        }
        if (UnderlinePatterns.NONE != src.getUnderline()) {
            dest.setUnderline(src.getUnderline());
        }
        if (null != src.getUnderlineColor()) {
            dest.setUnderlineColor(src.getUnderlineColor());
        }
    }

    public static void styleParagraph(XWPFParagraph dest, IRunBody src) {
        if (null == dest || null == src || !(src instanceof XWPFParagraph)) {
            return;
        }
        XWPFParagraph srcParagraph = (XWPFParagraph)src;
        StyleUtils.styleParagraph(dest, StyleUtils.retriveParagraphStyle(srcParagraph));
    }

    public static void styleParagraph(XWPFParagraph paragraph, ParagraphStyle style) {
        if (null == paragraph || null == style) {
            return;
        }
        StyleUtils.stylePpr(paragraph, style);
        StyleUtils.styleParaRpr(paragraph, style.getGlyphStyle());
    }

    public static void styleTable(XWPFTable table, TableStyle tableStyle) {
        if (null == table || null == tableStyle) {
            return;
        }
        TableTools.setWidth(table, tableStyle.getWidth(), tableStyle.getColWidths());
        TableTools.setBorder((arg_0, arg_1, arg_2, arg_3) -> ((XWPFTable)table).setLeftBorder(arg_0, arg_1, arg_2, arg_3), tableStyle.getLeftBorder());
        TableTools.setBorder((arg_0, arg_1, arg_2, arg_3) -> ((XWPFTable)table).setRightBorder(arg_0, arg_1, arg_2, arg_3), tableStyle.getRightBorder());
        TableTools.setBorder((arg_0, arg_1, arg_2, arg_3) -> ((XWPFTable)table).setTopBorder(arg_0, arg_1, arg_2, arg_3), tableStyle.getTopBorder());
        TableTools.setBorder((arg_0, arg_1, arg_2, arg_3) -> ((XWPFTable)table).setBottomBorder(arg_0, arg_1, arg_2, arg_3), tableStyle.getBottomBorder());
        TableTools.setBorder((arg_0, arg_1, arg_2, arg_3) -> ((XWPFTable)table).setInsideHBorder(arg_0, arg_1, arg_2, arg_3), tableStyle.getInsideHBorder());
        TableTools.setBorder((arg_0, arg_1, arg_2, arg_3) -> ((XWPFTable)table).setInsideVBorder(arg_0, arg_1, arg_2, arg_3), tableStyle.getInsideVBorder());
        if (null != tableStyle.getAlign()) {
            table.setTableAlignment(tableStyle.getAlign());
        }
        table.setCellMargins(tableStyle.getTopCellMargin(), tableStyle.getLeftCellMargin(), tableStyle.getBottomCellMargin(), tableStyle.getRightCellMargin());
        if (null != tableStyle.getIndentation()) {
            CTTbl ctTbl = table.getCTTbl();
            CTTblPr tPr = ctTbl.getTblPr() != null ? ctTbl.getTblPr() : ctTbl.addNewTblPr();
            CTTblWidth tw = tPr.isSetTblInd() ? tPr.getTblInd() : tPr.addNewTblInd();
            tw.setType(STTblWidth.DXA);
            tw.setW(BigInteger.valueOf(UnitUtils.cm2Twips(tableStyle.getIndentation())));
        }
    }

    public static void styleTableRow(XWPFTableRow row, RowStyle rowStyle) {
        boolean repeated;
        CTTrPr properties;
        if (null == row || null == rowStyle) {
            return;
        }
        int height = rowStyle.getHeight();
        CTRow ctRow = row.getCtRow();
        CTTrPr cTTrPr = properties = ctRow.isSetTrPr() ? ctRow.getTrPr() : ctRow.addNewTrPr();
        if (0 != height) {
            row.setHeight(height);
            CTHeight h = properties.sizeOfTrHeightArray() == 0 ? properties.addNewTrHeight() : properties.getTrHeightArray(0);
            String heightRule = rowStyle.getHeightRule();
            if ("exact".equals(heightRule)) {
                h.setHRule(STHeightRule.EXACT);
            } else if ("atleast".equals(heightRule)) {
                h.setHRule(STHeightRule.AT_LEAST);
            } else {
                h.setHRule(STHeightRule.AUTO);
            }
        }
        if (repeated = rowStyle.isRepeated()) {
            CTOnOff tblHeader = properties.sizeOfTblHeaderArray() == 0 ? properties.addNewTblHeader() : properties.getTblHeaderArray(0);
            tblHeader.setVal(XWPFOnOff.ON);
        }
    }

    public static void styleTableCell(XWPFTableCell cell, CellStyle cellStyle) {
        if (null == cell || null == cellStyle) {
            return;
        }
        if (null != cellStyle.getVertAlign()) {
            cell.setVerticalAlignment(cellStyle.getVertAlign());
        }
        if (null != cellStyle.getBackgroundColor()) {
            CTTc ctTc = cell.getCTTc();
            CTTcPr pr = ctTc.isSetTcPr() ? ctTc.getTcPr() : ctTc.addNewTcPr();
            CTShd shd = pr.isSetShd() ? pr.getShd() : pr.addNewShd();
            XWPFShadingPattern shadingPattern = cellStyle.getShadingPattern();
            if (null == shadingPattern) {
                shd.setVal(STShd.CLEAR);
            } else {
                shd.setVal(STShd.Enum.forInt((int)shadingPattern.getValue()));
            }
            shd.setColor((Object)"auto");
            shd.setFill((Object)cellStyle.getBackgroundColor());
        }
    }

    private static void styleParaRpr(CTParaRPr pr, Style style) {
        String westernFontFamily;
        UnderlinePatterns underlinePatern;
        if (null == pr || null == style) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)style.getColor())) {
            CTColor color = pr.isSetColor() ? pr.getColor() : pr.addNewColor();
            color.setVal((Object)style.getColor());
        }
        if (null != style.isItalic()) {
            CTOnOff italic = pr.isSetI() ? pr.getI() : pr.addNewI();
            italic.setVal(style.isItalic() != false ? XWPFOnOff.ON : XWPFOnOff.OFF);
        }
        if (null != style.isBold()) {
            CTOnOff bold = pr.isSetB() ? pr.getB() : pr.addNewB();
            bold.setVal(style.isBold() != false ? XWPFOnOff.ON : XWPFOnOff.OFF);
        }
        if (0.0 != style.getFontSize() && -1.0 != style.getFontSize()) {
            BigDecimal bd = BigDecimal.valueOf(style.getFontSize());
            CTHpsMeasure ctSize = pr.isSetSz() ? pr.getSz() : pr.addNewSz();
            ctSize.setVal(bd.multiply(BigDecimal.valueOf(2L)).setScale(0, RoundingMode.HALF_UP).toBigInteger());
        }
        if (null != style.isStrike()) {
            CTOnOff strike = pr.isSetStrike() ? pr.getStrike() : pr.addNewStrike();
            strike.setVal(style.isStrike() != false ? XWPFOnOff.ON : XWPFOnOff.OFF);
        }
        if (null != (underlinePatern = style.getUnderlinePatterns())) {
            CTUnderline underline = pr.isSetU() ? pr.getU() : pr.addNewU();
            underline.setVal(STUnderline.Enum.forInt((int)underlinePatern.getValue()));
            if (null != style.getUnderlineColor()) {
                String color = style.getUnderlineColor();
                SimpleValue svColor = null;
                if (color.equals("auto")) {
                    STHexColorAuto hexColor = STHexColorAuto.Factory.newInstance();
                    hexColor.set((StringEnumAbstractBase)STHexColorAuto.Enum.forString((String)color));
                    svColor = (SimpleValue)hexColor;
                } else {
                    STHexColorRGB rgbColor = STHexColorRGB.Factory.newInstance();
                    rgbColor.setStringValue(color);
                    svColor = (SimpleValue)rgbColor;
                }
                underline.setColor((Object)svColor);
            }
        }
        CTFonts fonts = pr.isSetRFonts() ? pr.getRFonts() : pr.addNewRFonts();
        String fontFamily = style.getFontFamily();
        if (StringUtils.isNotBlank((CharSequence)fontFamily)) {
            fonts.setEastAsia(fontFamily);
            fonts.setAscii(fontFamily);
            fonts.setHAnsi(fontFamily);
            fonts.setCs(fontFamily);
        }
        if (StringUtils.isNotBlank((CharSequence)(westernFontFamily = style.getWesternFontFamily()))) {
            fonts.setAscii(westernFontFamily);
            fonts.setHAnsi(westernFontFamily);
            fonts.setCs(westernFontFamily);
        }
    }

    public static void styleParaRpr(XWPFParagraph paragraph, Style style) {
        if (null == paragraph || null == style) {
            return;
        }
        CTP ctp = paragraph.getCTP();
        CTPPr pPr = ctp.isSetPPr() ? ctp.getPPr() : ctp.addNewPPr();
        CTParaRPr pr = pPr.isSetRPr() ? pPr.getRPr() : pPr.addNewRPr();
        StyleUtils.styleParaRpr(pr, style);
    }

    public static void stylePpr(XWPFParagraph paragraph, ParagraphStyle style) {
        CTPBdr ct;
        BigInteger bi;
        CTInd indent;
        CTP ctp;
        if (null == paragraph || null == style) {
            return;
        }
        if (null != style.getAlign()) {
            paragraph.setAlignment(style.getAlign());
        }
        if (null != style.getSpacing()) {
            paragraph.setSpacingBetween(style.getSpacing().doubleValue(), null == style.getSpacingRule() ? LineSpacingRule.AUTO : style.getSpacingRule());
        }
        if (null != style.getSpacingBeforeLines()) {
            paragraph.setSpacingBeforeLines(new BigInteger(String.valueOf(Math.round(style.getSpacingBeforeLines() * 100.0))).intValue());
        }
        if (null != style.getSpacingAfterLines()) {
            paragraph.setSpacingAfterLines(new BigInteger(String.valueOf(Math.round(style.getSpacingAfterLines() * 100.0))).intValue());
        }
        if (null != style.getSpacingBefore()) {
            paragraph.setSpacingBefore(UnitUtils.point2Twips(style.getSpacingBefore()));
        }
        if (null != style.getSpacingAfter()) {
            paragraph.setSpacingAfter(UnitUtils.point2Twips(style.getSpacingAfter()));
        }
        CTPPr pr = (ctp = paragraph.getCTP()).isSetPPr() ? ctp.getPPr() : ctp.addNewPPr();
        CTInd cTInd = indent = pr.isSetInd() ? pr.getInd() : pr.addNewInd();
        if (null != style.getIndentLeftChars()) {
            bi = new BigInteger(String.valueOf(Math.round(style.getIndentLeftChars() * 100.0)));
            indent.setLeftChars(bi);
            if (indent.isSetLeft()) {
                indent.unsetLeft();
            }
        }
        if (null != style.getIndentRightChars()) {
            bi = new BigInteger(String.valueOf(Math.round(style.getIndentRightChars() * 100.0)));
            indent.setRightChars(bi);
            if (indent.isSetRight()) {
                indent.unsetRight();
            }
        }
        if (null != style.getIndentHangingChars()) {
            bi = new BigInteger(String.valueOf(Math.round(style.getIndentHangingChars() * 100.0)));
            indent.setHangingChars(bi);
            if (indent.isSetHanging()) {
                indent.unsetHanging();
            }
        }
        if (null != style.getIndentFirstLineChars()) {
            bi = new BigInteger(String.valueOf(Math.round(style.getIndentFirstLineChars() * 100.0)));
            indent.setFirstLineChars(bi);
            if (indent.isSetFirstLine()) {
                indent.unsetFirstLine();
            }
        }
        CTPBdr cTPBdr = ct = pr.isSetPBdr() ? pr.getPBdr() : pr.addNewPBdr();
        if (null != style.getLeftBorder()) {
            StyleUtils.styleCTBorder(ct.isSetLeft() ? ct.getLeft() : ct.addNewLeft(), style.getLeftBorder());
        }
        if (null != style.getTopBorder()) {
            StyleUtils.styleCTBorder(ct.isSetTop() ? ct.getTop() : ct.addNewTop(), style.getTopBorder());
        }
        if (null != style.getRightBorder()) {
            StyleUtils.styleCTBorder(ct.isSetRight() ? ct.getRight() : ct.addNewRight(), style.getRightBorder());
        }
        if (null != style.getBottomBorder()) {
            StyleUtils.styleCTBorder(ct.isSetBottom() ? ct.getBottom() : ct.addNewBottom(), style.getBottomBorder());
        }
        if (null != style.getBackgroundColor()) {
            CTShd shd = pr.isSetShd() ? pr.getShd() : pr.addNewShd();
            XWPFShadingPattern shadingPattern = style.getShadingPattern();
            if (null == shadingPattern) {
                shd.setVal(STShd.CLEAR);
            } else {
                shd.setVal(STShd.Enum.forInt((int)shadingPattern.getValue()));
            }
            shd.setColor((Object)"auto");
            shd.setFill((Object)style.getBackgroundColor());
        }
        if (null != style.getStyleId()) {
            paragraph.setStyle(style.getStyleId());
        }
        if (null != style.getKeepLines()) {
            CTOnOff ctKeepLines = pr.isSetKeepLines() ? pr.getKeepLines() : pr.addNewKeepLines();
            ctKeepLines.setVal(style.getKeepLines() != false ? XWPFOnOff.ON : XWPFOnOff.OFF);
        }
        if (null != style.getKeepNext()) {
            paragraph.setKeepNext(style.getKeepNext().booleanValue());
        }
        if (null != style.getPageBreakBefore()) {
            paragraph.setPageBreak(style.getPageBreakBefore().booleanValue());
        }
        if (null != style.getWidowControl()) {
            CTOnOff ctWC = pr.isSetWidowControl() ? pr.getWidowControl() : pr.addNewWidowControl();
            ctWC.setVal(style.getWidowControl() != false ? XWPFOnOff.ON : XWPFOnOff.OFF);
        }
        if (null != style.getAllowWordBreak()) {
            CTOnOff ctWW = pr.isSetWordWrap() ? pr.getWordWrap() : pr.addNewWordWrap();
            ctWW.setVal(style.getAllowWordBreak() != false ? XWPFOnOff.OFF : XWPFOnOff.ON);
        }
        if (null != style.getNumId()) {
            paragraph.setNumID(BigInteger.valueOf(style.getNumId()));
        }
        if (null != style.getLvl()) {
            paragraph.setNumILvl(BigInteger.valueOf(style.getLvl()));
        }
    }

    public static void styleCTBorder(CTBorder b, BorderStyle style) {
        if (null != style.getType()) {
            b.setVal(STBorder.Enum.forString((String)style.getType().toString().toLowerCase()));
        }
        b.setSz(BigInteger.valueOf(style.getSize()));
        b.setSpace(BigInteger.valueOf(style.getSpace()));
        if (null != style.getColor()) {
            b.setColor((Object)style.getColor());
        }
    }

    public static Style retriveStyle(XWPFRun run) {
        if (null == run) {
            return null;
        }
        Style.StyleBuilder builder = Style.builder().buildColor(run.getColor()).buildFontFamily(run.getFontFamily(XWPFRun.FontCharRange.eastAsia)).buildWesternFontFamily(run.getFontFamily(XWPFRun.FontCharRange.ascii)).buildFontSize(run.getFontSize());
        if (run.isBold()) {
            builder.buildBold();
        }
        if (run.isItalic()) {
            builder.buildItalic();
        }
        if (run.isStrikeThrough()) {
            builder.buildStrike();
        }
        return builder.build();
    }

    public static ParagraphStyle retriveParagraphStyle(XWPFParagraph paragraph) {
        double spacingBetween;
        int spacingAfter;
        int spacingBefore;
        int spacingAfterLines;
        CTPPr pr;
        if (null == paragraph) {
            return null;
        }
        ParagraphStyle.Builder builder = ParagraphStyle.builder();
        CTP ctp = paragraph.getCTP();
        CTPPr cTPPr = pr = ctp.isSetPPr() ? ctp.getPPr() : ctp.addNewPPr();
        if (pr.isSetWordWrap() && (pr.getWordWrap().getVal() == XWPFOnOff.X_1 || pr.getWordWrap().getVal() == XWPFOnOff.FALSE || pr.getWordWrap().getVal() == XWPFOnOff.OFF)) {
            builder.withAllowWordBreak(true);
        }
        if (pr.isSetPBdr()) {
            CTPBdr ct = pr.getPBdr();
            if (ct.isSetLeft()) {
                builder.withLeftBorder(StyleUtils.retriveBorderStyle(ct.getLeft()));
            }
            if (ct.isSetTop()) {
                builder.withTopBorder(StyleUtils.retriveBorderStyle(ct.getTop()));
            }
            if (ct.isSetRight()) {
                builder.withRightBorder(StyleUtils.retriveBorderStyle(ct.getRight()));
            }
            if (ct.isSetBottom()) {
                builder.withBottomBorder(StyleUtils.retriveBorderStyle(ct.getBottom()));
            }
        }
        if (pr.isSetShd()) {
            CTShd shd = pr.getShd();
            builder.withShadingPattern(XWPFShadingPattern.valueOf(shd.getVal().intValue()));
            if (shd.isSetFill()) {
                builder.withBackgroundColor(shd.xgetFill().getStringValue());
            }
        }
        builder.withAlign(paragraph.getAlignment());
        int spacingBeforeLines = paragraph.getSpacingBeforeLines();
        if (-1 != spacingBeforeLines) {
            builder.withSpacingBeforeLines((float)spacingBeforeLines / 100.0f);
        }
        if (-1 != (spacingAfterLines = paragraph.getSpacingAfterLines())) {
            builder.withSpacingAfterLines((float)spacingAfterLines / 100.0f);
        }
        if (-1 != (spacingBefore = paragraph.getSpacingBefore())) {
            builder.withSpacingBefore(UnitUtils.twips2Point(spacingBefore));
        }
        if (-1 != (spacingAfter = paragraph.getSpacingAfter())) {
            builder.withSpacingAfter(UnitUtils.twips2Point(spacingAfter));
        }
        if (-1.0 != (spacingBetween = paragraph.getSpacingBetween())) {
            builder.withSpacing(spacingBetween);
            builder.withSpacingRule(paragraph.getSpacingLineRule());
        }
        return builder.build();
    }

    public static BorderStyle retriveBorderStyle(CTBorder border) {
        BorderStyle.Builder borderBuilder = BorderStyle.builder();
        if (border.isSetColor()) {
            borderBuilder.withColor(border.xgetColor().getStringValue());
        }
        if (border.isSetSz()) {
            borderBuilder.withSize(border.getSz().intValue());
        }
        if (border.getVal() != null) {
            borderBuilder.withType(XWPFTable.XWPFBorderType.valueOf((String)border.getVal().toString().toUpperCase()));
        }
        return borderBuilder.build();
    }

    public static Style retriveStyleFromCss(Map<String, String> propertyValues) {
        Style.StyleBuilder builder = Style.builder();
        if (propertyValues != null) {
            String style = propertyValues.get("font-style");
            String weight = propertyValues.get("font-weight");
            String color = propertyValues.get("color");
            String size = propertyValues.get("font-size");
            if (StringUtils.isNotBlank((CharSequence)style) && "italic".equalsIgnoreCase(style)) {
                builder.buildItalic();
            }
            if (StringUtils.isNotBlank((CharSequence)size)) {
                // empty if block
            }
            if (StringUtils.isNotBlank((CharSequence)weight)) {
                builder.buildBold();
            }
            if (StringUtils.isNotBlank((CharSequence)color)) {
                String rgb = StyleUtils.toRgb(color);
                builder.buildColor(rgb);
            }
        } else {
            return null;
        }
        return builder.build();
    }

    public static ParagraphStyle retriveParagraphStyleFromCss(Map<String, String> propertyValues) {
        ParagraphStyle.Builder builder = ParagraphStyle.builder();
        if (propertyValues != null) {
            String background = propertyValues.get("background");
            String color = propertyValues.get("color");
            if (StringUtils.isNotBlank((CharSequence)background)) {
                builder.withBackgroundColor(StyleUtils.toRgb(background));
            }
            if (StringUtils.isNotBlank((CharSequence)color)) {
                String rgb = StyleUtils.toRgb(color);
                builder.withDefaultTextStyle(Style.builder().buildColor(rgb).build());
            }
        } else {
            return null;
        }
        return builder.build();
    }

    public static String toRgb(String color) {
        if (color.toUpperCase().startsWith("RGB")) {
            String val = color.substring(color.indexOf("(") + 1, color.lastIndexOf(")"));
            String[] rgbArr = val.split(",");
            return String.format("%02x%02x%02x", Integer.valueOf(rgbArr[0]), Integer.valueOf(rgbArr[1]), Integer.valueOf(rgbArr[2]));
        }
        try {
            CssRgb valueOf = CssRgb.valueOf(color.toUpperCase());
            if (null != valueOf) {
                return valueOf.getRgb().substring(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!color.startsWith("#")) {
            return null;
        }
        if (color.length() == 7) {
            return color.substring(1);
        }
        if (color.length() == 4) {
            return String.format("%c%c%c%c%c%c", Character.valueOf(color.charAt(1)), Character.valueOf(color.charAt(1)), Character.valueOf(color.charAt(2)), Character.valueOf(color.charAt(2)), Character.valueOf(color.charAt(3)), Character.valueOf(color.charAt(3)));
        }
        return color.length() > 7 ? color.substring(1, 7) : color.substring(1);
    }

    private static CTRPr getRunProperties(XWPFRun run) {
        return run.getCTR().isSetRPr() ? run.getCTR().getRPr() : run.getCTR().addNewRPr();
    }
}

