/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.auth.permission;

import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.auth.api.PermissionServiceApi;
import cn.stylefeng.roses.kernel.auth.api.SessionManagerApi;
import cn.stylefeng.roses.kernel.auth.api.exception.AuthException;
import cn.stylefeng.roses.kernel.auth.api.exception.enums.AuthExceptionEnum;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PermissionServiceImpl
implements PermissionServiceApi {
    @Resource
    private SessionManagerApi sessionManagerApi;

    public void checkPermission(String token, String requestUrl) {
        if (StrUtil.isEmpty((CharSequence)token)) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.TOKEN_GET_ERROR);
        }
        LoginUser session = this.sessionManagerApi.getSession(token);
        if (session == null) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.AUTH_EXPIRED_ERROR);
        }
        Set resourceUrls = session.getResourceUrls();
        if (resourceUrls == null || resourceUrls.size() == 0) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.PERMISSION_RES_VALIDATE_ERROR);
        }
        if (!resourceUrls.contains(requestUrl)) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.PERMISSION_RES_VALIDATE_ERROR);
        }
    }
}

