/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.http;

import java.util.Enumeration;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.client.http.HttpReceiverOverHTTP;
import org.eclipse.jetty.client.http.HttpSenderOverHTTP;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;

public class HttpChannelOverHTTP
extends HttpChannel {
    private final HttpConnectionOverHTTP connection;
    private final HttpSenderOverHTTP sender;
    private final HttpReceiverOverHTTP receiver;

    public HttpChannelOverHTTP(HttpConnectionOverHTTP connection) {
        super(connection.getHttpDestination());
        this.connection = connection;
        this.sender = new HttpSenderOverHTTP(this);
        this.receiver = new HttpReceiverOverHTTP(this);
    }

    public HttpConnectionOverHTTP getHttpConnection() {
        return this.connection;
    }

    @Override
    public void send() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.sender.send(exchange);
        }
    }

    @Override
    public void proceed(HttpExchange exchange, Throwable failure) {
        this.sender.proceed(exchange, failure);
    }

    @Override
    public boolean abort(Throwable cause) {
        this.sender.abort(cause);
        return this.receiver.abort(cause);
    }

    public void receive() {
        this.receiver.receive();
    }

    @Override
    public void exchangeTerminated(Result result) {
        super.exchangeTerminated(result);
        if (result.isSucceeded()) {
            HttpFields responseHeaders = result.getResponse().getHeaders();
            Enumeration values = responseHeaders.getValues(HttpHeader.CONNECTION.asString(), ",");
            if (values != null) {
                while (values.hasMoreElements()) {
                    if (!HttpHeaderValue.CLOSE.asString().equalsIgnoreCase((String)values.nextElement())) continue;
                    this.connection.close();
                    return;
                }
            }
            this.connection.release();
        } else {
            this.connection.close();
        }
    }

    @Override
    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

