/*
 * Decompiled with CFR 0.152.
 */
package test.java;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import main.java.com.UpYun;
import org.junit.Assert;
import org.junit.Test;

public class TestPicBucket {
    private static final String BUCKET_NAME = "sdkimg";
    private static final String OPERATOR_NAME = "tester";
    private static final String OPERATOR_PWD = "grjxv2mxELR3";
    private static final String DIR_ROOT = "/";
    private static final String PIC_NAME = "sample.jpeg";
    private static final String SAMPLE_PIC_FILE = System.getProperty("user.dir") + "/sample.jpeg";
    UpYun upyun = new UpYun("sdkimg", "tester", "grjxv2mxELR3");

    @Test
    public void testWritePic() throws IOException {
        String filePath = "/sample.jpeg";
        File file = new File(SAMPLE_PIC_FILE);
        this.upyun.setTimeout(120);
        this.upyun.setContentMD5(UpYun.md5(file));
        this.upyun.setFileSecret("bac");
        boolean result = this.upyun.writeFile(filePath, file, true);
        Assert.assertTrue((boolean)result);
        String width = this.upyun.getPicWidth();
        String height = this.upyun.getPicHeight();
        String frames = this.upyun.getPicFrames();
        String type = this.upyun.getPicType();
        Assert.assertTrue((width != null && !"".equals(width) ? 1 : 0) != 0);
        Assert.assertTrue((height != null && !"".equals(height) ? 1 : 0) != 0);
        Assert.assertTrue((frames != null && !"".equals(frames) ? 1 : 0) != 0);
        Assert.assertTrue((type != null && !"".equals(type) ? 1 : 0) != 0);
    }

    @Test
    public void testGmkerl() throws IOException {
        String filePath = "/gmkerl.jpg";
        File file = new File(SAMPLE_PIC_FILE);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(UpYun.PARAMS.KEY_X_GMKERL_TYPE.getValue(), UpYun.PARAMS.VALUE_FIX_BOTH.getValue());
        params.put(UpYun.PARAMS.KEY_X_GMKERL_VALUE.getValue(), "150x150");
        params.put(UpYun.PARAMS.KEY_X_GMKERL_QUALITY.getValue(), "95");
        params.put(UpYun.PARAMS.KEY_X_GMKERL_UNSHARP.getValue(), "true");
        params.put(UpYun.PARAMS.KEY_X_GMKERL_THUMBNAIL.getValue(), "small");
        boolean result = this.upyun.writeFile(filePath, file, true, params);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testRotate() throws IOException {
        String filePath = "/rotate.jpg";
        File file = new File(SAMPLE_PIC_FILE);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(UpYun.PARAMS.KEY_X_GMKERL_ROTATE.getValue(), UpYun.PARAMS.VALUE_ROTATE_90.getValue());
        boolean result = this.upyun.writeFile(filePath, file, true, params);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testGrop() throws IOException {
        String filePath = "/crop.jpg";
        File file = new File(SAMPLE_PIC_FILE);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(UpYun.PARAMS.KEY_X_GMKERL_CROP.getValue(), "50,50,300,300");
        boolean result = this.upyun.writeFile(filePath, file, true, params);
        Assert.assertTrue((boolean)result);
    }
}

