/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.guarantee;

import com.dangdang.ddframe.job.lite.api.listener.AbstractDistributeOnceElasticJobListener;
import com.dangdang.ddframe.job.lite.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.lite.internal.guarantee.GuaranteeNode;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractJobListener;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractListenerManager;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import java.util.List;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;

public final class GuaranteeListenerManager
extends AbstractListenerManager {
    private final GuaranteeNode guaranteeNode;
    private final List<ElasticJobListener> elasticJobListeners;

    public GuaranteeListenerManager(CoordinatorRegistryCenter regCenter, String jobName, List<ElasticJobListener> elasticJobListeners) {
        super(regCenter, jobName);
        this.guaranteeNode = new GuaranteeNode(jobName);
        this.elasticJobListeners = elasticJobListeners;
    }

    @Override
    public void start() {
        this.addDataListener(new StartedNodeRemovedJobListener());
        this.addDataListener(new CompletedNodeRemovedJobListener());
    }

    class CompletedNodeRemovedJobListener
    extends AbstractJobListener {
        CompletedNodeRemovedJobListener() {
        }

        @Override
        protected void dataChanged(String path, TreeCacheEvent.Type eventType, String data) {
            if (TreeCacheEvent.Type.NODE_REMOVED == eventType && GuaranteeListenerManager.this.guaranteeNode.isCompletedRootNode(path)) {
                for (ElasticJobListener each : GuaranteeListenerManager.this.elasticJobListeners) {
                    if (!(each instanceof AbstractDistributeOnceElasticJobListener)) continue;
                    ((AbstractDistributeOnceElasticJobListener)each).notifyWaitingTaskComplete();
                }
            }
        }
    }

    class StartedNodeRemovedJobListener
    extends AbstractJobListener {
        StartedNodeRemovedJobListener() {
        }

        @Override
        protected void dataChanged(String path, TreeCacheEvent.Type eventType, String data) {
            if (TreeCacheEvent.Type.NODE_REMOVED == eventType && GuaranteeListenerManager.this.guaranteeNode.isStartedRootNode(path)) {
                for (ElasticJobListener each : GuaranteeListenerManager.this.elasticJobListeners) {
                    if (!(each instanceof AbstractDistributeOnceElasticJobListener)) continue;
                    ((AbstractDistributeOnceElasticJobListener)each).notifyWaitingTaskStart();
                }
            }
        }
    }
}

